/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.ecore.delegates.execution.Program;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElementParameter;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.erl.execute.RuleExecutorFactory;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;

public class EvlConstraint
implements Program<Optional<UnsatisfiedConstraint>> {
    private final Constraint module;
    private List<ParseProblem> parseProblems = new ArrayList<ParseProblem>();
    private final Throwable error;
    private final IEvlContext context;

    public EvlConstraint(Throwable ex, List<ParseProblem> problems) {
        this(null, ex, problems, null);
    }

    public EvlConstraint(Constraint program, List<ParseProblem> problems, IEvlContext context) {
        this(program, null, problems, context);
    }

    public EvlConstraint() {
        this(null, null, Collections.emptyList(), null);
    }

    public EvlConstraint error(IOException ex) {
        return new EvlConstraint(ex, Collections.singletonList(new ParseProblem("Exception during parsing: " + ex.getLocalizedMessage(), 0)));
    }

    public EvlConstraint error(RecognitionException ex) {
        ParseProblem problem = new ParseProblem();
        problem.setLine(ex.line);
        problem.setColumn(ex.charPositionInLine);
        problem.setReason(ex.getMessage());
        return new EvlConstraint((Throwable)ex, Collections.singletonList(problem));
    }

    public EvlConstraint error(Throwable ex, Token next) {
        ParseProblem problem = new ParseProblem();
        problem.setLine(next.getLine());
        problem.setColumn(next.getCharPositionInLine());
        problem.setReason("mismatched input: '" + next.getText() + "'");
        return new EvlConstraint(ex, Collections.singletonList(problem));
    }

    public EvlConstraint error(IllegalStateException ex) {
        return new EvlConstraint(ex, Collections.singletonList(new ParseProblem("Exception during invariant evaluation: " + ex.getLocalizedMessage(), 0)));
    }

    @Override
    public Optional<UnsatisfiedConstraint> execute(EObject eObject, IModel model) throws Throwable {
        if (this.error != null) {
            throw this.error;
        }
        if (!this.parseProblems.isEmpty()) {
            throw new IllegalStateException(this.parseProblems.stream().map(pp -> pp.toString()).collect(Collectors.joining("; ")));
        }
        RuleExecutorFactory executorFactory = this.context.getExecutorFactory();
        if (!this.context.getModelRepository().getModels().contains(model)) {
            this.context.getModelRepository().addModel(model);
        }
        return (Optional)executorFactory.execute((IExecutableModuleElementParameter)this.module, (IEolContext)this.context, (Object)eObject);
    }

    private EvlConstraint(Constraint module, Throwable error, List<ParseProblem> problems, IEvlContext context) {
        this.module = module;
        this.error = error;
        this.parseProblems.addAll(problems);
        this.context = context;
    }
}

