/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.cdo.dt;

import org.eclipse.epsilon.common.dt.launching.dialogs.AbstractModelConfigurationDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CDOModelConfigurationDialog
extends AbstractModelConfigurationDialog {
    private Text txtURL;
    private Text txtName;
    private Text txtPath;
    private Text txtBranch;
    private Text txtCDOInitial;
    private Text txtCDORChunk;
    private Text txtCDORPrefetch;
    private Button btnCDOFeatAnalyzer;
    private Button btnCreateIfMissing;

    protected String getModelName() {
        return "CDO Model";
    }

    protected String getModelType() {
        return "cdo";
    }

    protected void createGroups(Composite parent) {
        super.createGroups(parent);
        this.createAccessGroup(parent);
        this.createPrefetchGroup(parent);
        this.createLoadStoreOptionsGroup(parent);
    }

    protected void createPrefetchGroup(Composite parent) {
        Composite groupContent = CDOModelConfigurationDialog.createGroupContainer((Composite)parent, (String)"Prefetching", (int)2);
        Label lblCDOInitial = new Label(groupContent, 0);
        lblCDOInitial.setText("Initial collection prefetch size:");
        this.txtCDOInitial = new Text(groupContent, 2048);
        this.txtCDOInitial.setText("0");
        this.txtCDOInitial.setLayoutData((Object)new GridData(4, 128, true, false));
        Label lblCDORChunk = new Label(groupContent, 0);
        lblCDORChunk.setText("Collection resolving chunk size:");
        this.txtCDORChunk = new Text(groupContent, 2048);
        this.txtCDORChunk.setText("300");
        this.txtCDORChunk.setLayoutData((Object)new GridData(4, 128, true, false));
        Label lblCDORPrefetch = new Label(groupContent, 0);
        lblCDORPrefetch.setText("Revision prefetch size:");
        this.txtCDORPrefetch = new Text(groupContent, 2048);
        this.txtCDORPrefetch.setText("100");
        this.txtCDORPrefetch.setLayoutData((Object)new GridData(4, 128, true, false));
        this.btnCDOFeatAnalyzer = new Button(groupContent, 32);
        this.btnCDOFeatAnalyzer.setText("Use CDO model-based feature analyzer");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.btnCDOFeatAnalyzer.setLayoutData((Object)gd);
    }

    protected void createAccessGroup(Composite parent) {
        Composite groupContent = CDOModelConfigurationDialog.createGroupContainer((Composite)parent, (String)"Repository access", (int)2);
        Label lblURL = new Label(groupContent, 0);
        lblURL.setText("URL:");
        this.txtURL = new Text(groupContent, 2048);
        this.txtURL.setText("tcp://localhost:2036");
        this.txtURL.setLayoutData((Object)new GridData(4, 128, true, false));
        Label lblName = new Label(groupContent, 0);
        lblName.setText("Repository:");
        this.txtName = new Text(groupContent, 2048);
        this.txtName.setText("repo1");
        this.txtName.setLayoutData((Object)new GridData(4, 128, true, false));
        Label lblBranch = new Label(groupContent, 0);
        lblBranch.setText("Branch:");
        this.txtBranch = new Text(groupContent, 2048);
        this.txtBranch.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtBranch.setToolTipText("Path to the branch (e.g. MAIN/branch1). Leave empty to use the main branch.");
        Label lblPath = new Label(groupContent, 0);
        lblPath.setText("Path:");
        this.txtPath = new Text(groupContent, 2048);
        this.txtPath.setText("/input.xmi");
        this.txtPath.setLayoutData((Object)new GridData(4, 128, true, false));
        Label lblCreateIfMissing = new Label(groupContent, 0);
        lblCreateIfMissing.setText("Create if missing:");
        this.btnCreateIfMissing = new Button(groupContent, 32);
    }

    protected void loadProperties() {
        super.loadProperties();
        if (this.properties != null) {
            this.txtURL.setText((String)this.properties.get((Object)"cdo.url"));
            this.txtName.setText((String)this.properties.get((Object)"cdo.repo"));
            this.txtPath.setText((String)this.properties.get((Object)"cdo.path"));
            this.btnCreateIfMissing.setSelection(this.properties.hasProperty("cdo.createMissingResource"));
            if (this.properties.hasProperty("cdo.branch")) {
                this.txtBranch.setText((String)this.properties.get((Object)"cdo.branch"));
            }
            if (this.properties.hasProperty("cdo.collection.initial")) {
                this.txtCDOInitial.setText((String)this.properties.get((Object)"cdo.collection.initial"));
            }
            if (this.properties.hasProperty("cdo.collection.rchunk")) {
                this.txtCDORChunk.setText((String)this.properties.get((Object)"cdo.collection.rchunk"));
            }
            if (this.properties.hasProperty("cdo.revprefetch")) {
                this.txtCDORPrefetch.setText((String)this.properties.get((Object)"cdo.revprefetch"));
            }
            this.btnCDOFeatAnalyzer.setSelection(this.properties.hasProperty("cdo.featureAnalyzer"));
        }
    }

    protected void storeProperties() {
        super.storeProperties();
        this.properties.put((Object)"cdo.url", (Object)this.txtURL.getText());
        this.properties.put((Object)"cdo.repo", (Object)this.txtName.getText());
        this.properties.put((Object)"cdo.path", (Object)this.txtPath.getText());
        if (this.btnCreateIfMissing.getSelection()) {
            this.properties.put((Object)"cdo.createMissingResource", (Object)"1");
        }
        this.properties.put((Object)"cdo.branch", (Object)this.txtBranch.getText());
        this.properties.put((Object)"cdo.collection.initial", (Object)this.txtCDOInitial.getText());
        this.properties.put((Object)"cdo.collection.rchunk", (Object)this.txtCDORChunk.getText());
        this.properties.put((Object)"cdo.revprefetch", (Object)this.txtCDORPrefetch.getText());
        if (this.btnCDOFeatAnalyzer.getSelection()) {
            this.properties.put((Object)"cdo.featureAnalyzer", (Object)"1");
        }
    }
}

