/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.types.AbstractType;
import org.eclipse.epsilon.emc.simulink.util.ReflectionLocalUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class Complex
extends AbstractType {
    private static final String COMPLEX_MATLAB_CLASS = "com.mathworks.matlab.types.Complex";
    private static Class<?> complex_class;

    public static boolean is(Object obj) {
        return Complex.getMatlabClass() == null ? false : Complex.getMatlabClass().isInstance(obj);
    }

    private static Class<?> getMatlabClass() {
        if (complex_class == null) {
            try {
                complex_class = ClassLoader.getSystemClassLoader().loadClass(COMPLEX_MATLAB_CLASS);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return complex_class;
    }

    public Complex(Object complex) {
        if (Complex.is(complex)) {
            this.object = complex;
        }
    }

    public Complex(MatlabEngine engine) {
        this();
        this.engine = engine;
    }

    @Override
    public Object getHandle() {
        return this.object;
    }

    public Complex(Double real, Double imag) {
        try {
            Constructor<?> constructor = Complex.getMatlabClass().getConstructor(Double.TYPE, Double.TYPE);
            this.object = constructor.newInstance(real, imag);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            System.out.println("Problem retrieving constructor of the complex type");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            System.out.println("Problem instantiating the complex type");
            e.printStackTrace();
        }
    }

    public Complex(Double real, Integer imag) {
        this(real, (Double)imag.doubleValue());
    }

    public Complex(Integer real, Double imag) {
        this((Double)real.doubleValue(), imag);
    }

    public Complex(Integer real, Integer imag) {
        this((Double)real.doubleValue(), (Double)imag.doubleValue());
    }

    public Complex() {
        this((Integer)0, (Integer)0);
    }

    public Double getReal() {
        try {
            return (Double)ReflectionLocalUtil.getFieldValue(this.object, "real");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setReal(Double real) throws Exception {
        ReflectionLocalUtil.setFieldValue(this.object, "real", real);
    }

    public void setReal(Integer real) throws Exception {
        this.setReal(real.doubleValue());
    }

    public Double getImag() {
        try {
            return (Double)ReflectionLocalUtil.getFieldValue(this.object, "imag");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setImag(Double imag) throws Exception {
        ReflectionLocalUtil.setFieldValue(this.object, "imag", imag);
    }

    public void setImag(Integer imag) throws Exception {
        this.setImag(imag.doubleValue());
    }

    public String toString() {
        Double imag = this.getImag();
        return String.valueOf(this.getReal().toString()) + (imag > 0.0 ? " +" : " ") + imag.toString() + "i";
    }

    @Override
    public Object getProperty(String property) throws EolRuntimeException {
        try {
            switch (property) {
                case "real": {
                    return this.getReal();
                }
                case "imag": {
                    return this.getImag();
                }
            }
        }
        catch (Exception e) {
            throw new EolRuntimeException((Throwable)e);
        }
        return null;
    }

    @Override
    public void setProperty(String property, Object value) throws EolRuntimeException {
        block12: {
            if (!(value instanceof Double) && !(value instanceof Integer)) break block12;
            try {
                switch (property) {
                    case "real": {
                        this.setReal((Double)value);
                    }
                    case "imag": {
                        this.setImag((Double)value);
                    }
                }
            }
            catch (Exception e) {
                throw new EolRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    protected void init() {
    }

    @Override
    protected Object getObject() {
        return this.object;
    }
}

