/*******************************************************************************
 * Copyright (c) 2008 The University of York.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     Louis Rose - initial API and implementation
 ******************************************************************************/
package org.eclipse.epsilon.egl.exceptions;

import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class EglRuntimeException extends EolRuntimeException {
	
	// Generated by Eclipse
	private static final long serialVersionUID = 2370066735399525557L;
	
	private final Throwable cause;
	private final int line;
	private final int column;
	
	
	public EglRuntimeException (EolRuntimeException ex) {
		super(ex.getReason(), ex.getAst());
		
		reason = ex.getReason();
		cause  = ex;
		line   = ex.getAst().getRegion().getStart().getLine();
		column = ex.getColumn();
		ast    = ex.getAst();
	}
	
	public EglRuntimeException (EolInternalException ex) {
		super(ex.getReason(), ex.getAst());
		
		final EglRuntimeException internal = (EglRuntimeException)ex.getInternal();
		
		reason = internal.getReason();
		cause  = internal.getCause();
		line   = ex.getLine();
		column = ex.getColumn();
		ast    = ex.getAst();
	}
	
	public EglRuntimeException(String reason, ModuleElement ast) {
		this(reason, null, ast);
	}
	
	public EglRuntimeException(Throwable cause) {
		this(cause.getMessage(), cause, 1, 1, null);
	}
	
	public EglRuntimeException(String reason, Throwable cause) {
		this(reason, cause, 1, 1, null);
	}
	
	public EglRuntimeException(String reason, Throwable cause, ModuleElement ast) {
		this(reason, cause, ast != null ? ast.getRegion().getStart().getLine() : 0, ast != null ? ast.getRegion().getStart().getColumn() : 0, ast);
	}
	
	private EglRuntimeException(String reason, Throwable cause, int line, int column, ModuleElement ast) {
		this.reason = reason;		
		this.cause  = cause;
		this.line   = line;
		this.column = column;
		this.ast    = ast;
	}


	@Override
	public Throwable getCause() {
		return cause;
	}
	
	@Override
	public int getLine() {
		return line;
	}
	
	@Override
	public int getColumn() {
		return column;
	}
	
	@Override
	public String getReason() {
		return reason;
	}
	
	@Override
	public String toString() {
		String result = super.toString();
		
		if (cause != null) {
			result += "\n\tCause: " + cause.toString();
		}
		
		return result;
	}
}
