/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.output;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.IAtom;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.util.common.xml.XmlWriter;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.output.OutputProperties;
import com.google.gdata.wireformats.output.XmlGenerator;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssGenerator
extends XmlGenerator<IAtom> {
    @Override
    public AltFormat getAltFormat() {
        return AltFormat.RSS;
    }

    @Override
    public Class<IAtom> getSourceType() {
        return IAtom.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generateXml(XmlWriter xw, OutputProperties outProps, IAtom source) throws IOException {
        if (source instanceof IFeed) {
            IFeed feed = (IFeed)source;
            if (!(feed instanceof BaseFeed)) throw new IllegalArgumentException("Feed was not an instance of BaseFeed");
            ((BaseFeed)feed).generateRss(xw, outProps.getExtensionProfile());
            return;
        } else {
            if (!(source instanceof IEntry)) throw new IllegalStateException("Unexpected source type: " + source);
            IEntry entry = (IEntry)source;
            if (!(entry instanceof BaseEntry)) throw new IllegalArgumentException("Entry was not an instance of BaseEntry");
            ((BaseEntry)entry).generateRss(xw, outProps.getExtensionProfile());
        }
    }
}

