/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.input;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Entry;
import com.google.gdata.data.Feed;
import com.google.gdata.data.IAtom;
import com.google.gdata.data.XmlEventSource;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.ContentCreationException;
import com.google.gdata.wireformats.input.InputProperties;
import com.google.gdata.wireformats.input.XmlInputParser;
import java.io.IOException;
import java.io.Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomDataParser
extends XmlInputParser<IAtom> {
    public AtomDataParser() {
        super(AltFormat.ATOM, IAtom.class);
    }

    @Override
    public <R extends IAtom> R parse(Reader inputReader, InputProperties inProps, Class<R> resultClass) throws IOException, ServiceException {
        Preconditions.checkNotNull(inProps.getExtensionProfile(), "No extension profile");
        IAtom result = (IAtom)this.createResult(resultClass);
        if (result instanceof BaseEntry) {
            BaseEntry<?> adaptedEntry;
            BaseEntry entryResult = (BaseEntry)result;
            entryResult.parseAtom(inProps.getExtensionProfile(), inputReader);
            if (resultClass == Entry.class && resultClass.isInstance(adaptedEntry = entryResult.getAdaptedEntry())) {
                result = (IAtom)resultClass.cast(adaptedEntry);
            }
        } else if (result instanceof BaseFeed) {
            BaseFeed<?, ?> adaptedFeed;
            BaseFeed feedResult = (BaseFeed)result;
            feedResult.parseAtom(inProps.getExtensionProfile(), inputReader);
            if (resultClass == Feed.class && resultClass.isInstance(adaptedFeed = feedResult.getAdaptedFeed())) {
                result = (IAtom)resultClass.cast(adaptedFeed);
            }
        } else {
            throw new ContentCreationException("Invalid result class: " + resultClass);
        }
        return (R)result;
    }

    @Override
    protected <R extends IAtom> R parse(XmlEventSource eventSource, InputProperties inProps, Class<R> resultClass) throws IOException, ServiceException {
        Preconditions.checkNotNull(inProps.getExtensionProfile(), "No extension profile");
        IAtom result = (IAtom)this.createResult(resultClass);
        if (result instanceof BaseEntry) {
            BaseEntry entryResult = (BaseEntry)result;
            entryResult.parseAtom(inProps.getExtensionProfile(), eventSource);
        } else if (result instanceof BaseFeed) {
            BaseFeed feedResult = (BaseFeed)result;
            feedResult.parseAtom(inProps.getExtensionProfile(), eventSource);
        } else {
            throw new ContentCreationException("Invalid result class: " + resultClass);
        }
        return (R)result;
    }
}

