/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.TypeHelper;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkElement;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkLine;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkPort;

public class SimulinkUtil {
    private static final String GET_BLOCK_HANDLE = "getSimulinkBlockHandle('?');";
    public static final String FIND = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On'";
    public static final String FIND_FOLLOW = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'FollowLinks', 'on'";
    private static final String FIND_BLOCKS_OF_TYPE_WITH_REFS = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'FollowLinks', 'on', 'BlockType', '?');";
    private static final String FIND_BLOCKS_OF_TYPE = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'BlockType', '?');";
    private static final String FIND_SYSTEM_BLOCKS_WITH_REFS = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'FollowLinks', 'on', 'Type', 'Block');";
    private static final String FIND_SYSTEM_BLOCKS = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'Type', 'Block');";
    private static final String FIND_SYSTEM_LINES_WITH_REFS = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'FollowLinks', 'on', 'Type', 'line');";
    private static final String FIND_SYSTEM_LINES = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'Type', 'line');";
    private static final String FIND_BLOCKS_AT_DEPTH = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'SearchDepth', ?, 'Type', 'Block');";
    private static final String FIND_BLOCKS_AT_DEPTH_WITH_REFS = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'FollowLinks', 'on', 'SearchDepth', ?, 'Type', 'Block');";
    private static final String CHILDREN_BLOCKS = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'SearchDepth', 1, 'Type', 'Block');";
    private static final String CHILDREN_BLOCKS_WITH_REFS = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'FollowLinks', 'on', 'SearchDepth', 1, 'Type', 'Block');";

    public static String getSimpleTypeName(String type) {
        if (type.indexOf("/") > -1) {
            String[] parts = type.split("/");
            return parts[parts.length - 1];
        }
        if (type.indexOf(".") > -1) {
            String[] parts = type.split("\\.");
            return parts[parts.length - 1];
        }
        return type;
    }

    public static String getTypePathInModel(SimulinkModel model, String type) {
        return String.valueOf(model.getSimulinkModelName()) + "/" + SimulinkUtil.getSimpleTypeName(type);
    }

    public static String handleMethod(ISimulinkElement obj, String methodName, Object[] parameters) {
        Double handle = obj.getHandle();
        return SimulinkUtil.handleMethod(handle, methodName, parameters);
    }

    public static String handleMethod(SimulinkModel obj, String methodName, Object[] parameters) {
        Double handle = obj.getHandle();
        return SimulinkUtil.handleMethod(handle, methodName, parameters);
    }

    private static String handleMethod(Object objHandle, String methodName, Object[] parameters) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("handle");
        list.addAll(Arrays.asList(parameters));
        return "handle = " + objHandle + "; " + SimulinkUtil.handleMethod(methodName, list.toArray());
    }

    public static String handleMethodWithResult(ISimulinkElement obj, String methodName, Object[] parameters) {
        Double handle = obj.getHandle();
        return SimulinkUtil.handleMethodWithResult(handle, methodName, parameters);
    }

    public static String handleMethodWithResult(SimulinkModel obj, String methodName, Object[] parameters) {
        Double handle = obj.getHandle();
        return SimulinkUtil.handleMethodWithResult(handle, methodName, parameters);
    }

    private static String handleMethodWithResult(Object objHandle, String methodName, Object[] parameters) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("handle");
        list.addAll(Arrays.asList(parameters));
        return "handle = " + objHandle + "; " + SimulinkUtil.handleMethodWithResult(methodName, list.toArray());
    }

    public static String handleMethodWithResult(String methodName, Object[] parameters) {
        return "result = " + SimulinkUtil.handleMethod(methodName, parameters);
    }

    public static String handleMethod(String methodName, Object[] parameters) {
        String cmd = methodName;
        if (parameters != null && parameters.length > 0) {
            cmd = String.valueOf(cmd) + "(" + parameters[0];
            int i = 1;
            while (i < parameters.length) {
                cmd = String.valueOf(cmd) + ", '" + String.valueOf(parameters[i]) + "'";
                ++i;
            }
            cmd = String.valueOf(cmd) + ");";
        }
        return cmd;
    }

    public static Double getHandle(String path, MatlabEngine engine) {
        try {
            return (Double)engine.evalWithResult(GET_BLOCK_HANDLE, path);
        }
        catch (MatlabException e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public static <T extends ISimulinkModelElement> List<T> getTypeList(Class<T> returnType, SimulinkModel model, MatlabEngine engine, Object elements) {
        ISimulinkModelElement instantiate;
        ArrayList<ISimulinkModelElement> list = new ArrayList<ISimulinkModelElement>();
        if (elements instanceof List) {
            try {
                for (Object element : (List)elements) {
                    Double handle;
                    ISimulinkModelElement instantiate2;
                    if (element instanceof String) {
                        String path = (String)element;
                        instantiate2 = (ISimulinkModelElement)SimulinkUtil.instantiate(returnType, model, engine, null, path);
                        if (instantiate2 == null) continue;
                        list.add(instantiate2);
                        continue;
                    }
                    if (!(element instanceof Double) || (instantiate2 = (ISimulinkModelElement)SimulinkUtil.instantiate(returnType, model, engine, handle = (Double)element, null)) == null) continue;
                    list.add(instantiate2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
        } else if (elements instanceof String) {
            ISimulinkModelElement instantiate3 = (ISimulinkModelElement)SimulinkUtil.instantiate(returnType, model, engine, null, (String)elements);
            if (instantiate3 != null) {
                list.add(instantiate3);
            }
        } else if (elements instanceof Double && (instantiate = (ISimulinkModelElement)SimulinkUtil.instantiate(returnType, model, engine, (Double)elements, null)) != null) {
            list.add(instantiate);
        }
        return list;
    }

    private static <T> T instantiate(Class<T> clazz, SimulinkModel model, MatlabEngine engine, Double handle, String path) {
        block3: {
            try {
                if (handle != null) {
                    return clazz.getConstructor(SimulinkModel.class, MatlabEngine.class, Double.class).newInstance(new Object[]{model, engine, handle});
                }
                if (path == null) break block3;
                return clazz.getConstructor(String.class, SimulinkModel.class, MatlabEngine.class).newInstance(new Object[]{path, model, engine});
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static List<SimulinkBlock> getSimulinkBlocks(SimulinkModel model, MatlabEngine engine, Object handles) {
        return SimulinkUtil.getTypeList(SimulinkBlock.class, model, engine, handles);
    }

    public static List<SimulinkLine> getSimulinkLines(SimulinkModel model, MatlabEngine engine, Object handles) {
        return SimulinkUtil.getTypeList(SimulinkLine.class, model, engine, handles);
    }

    public static List<SimulinkPort> getSimulinkPorts(SimulinkModel model, MatlabEngine engine, Object handles) {
        return SimulinkUtil.getTypeList(SimulinkPort.class, model, engine, handles);
    }

    public static List<SimulinkBlock> getChildren(SimulinkModel model, MatlabEngine engine, SimulinkBlock block) throws MatlabException {
        return SimulinkUtil.getSimulinkBlocks(model, engine, engine.evalWithResult(CHILDREN_BLOCKS, block.getPath()));
    }

    public static List<SimulinkBlock> getChildren(SimulinkModel model, MatlabEngine engine) throws MatlabException {
        return SimulinkUtil.getSimulinkBlocks(model, engine, engine.evalWithResult(CHILDREN_BLOCKS, model.getSimulinkModelName(), model.getSimulinkModelName()));
    }

    public static List<ISimulinkModelElement> findBlocks(SimulinkModel model, MatlabEngine engine, Integer depth) throws MatlabException {
        return SimulinkUtil.getSimulinkBlocks(model, engine, engine.evalWithResult(FIND_BLOCKS_AT_DEPTH, model.getSimulinkModelName(), depth)).stream().map(e -> e).collect(Collectors.toList());
    }

    public static List<ISimulinkModelElement> getAllSimulinkFromModel(SimulinkModel model, MatlabEngine engine, TypeHelper.Kind kind) throws MatlabException {
        String cmd = model.isFollowLinks() ? FIND_SYSTEM_BLOCKS_WITH_REFS : FIND_SYSTEM_BLOCKS;
        return SimulinkUtil.getSimulinkBlocks(model, engine, engine.evalWithResult(cmd, model.getSimulinkModelName())).stream().map(e -> e).collect(Collectors.toList());
    }

    public static List<ISimulinkModelElement> getAllSimulinkBlocksFromModel(SimulinkModel model, MatlabEngine engine) throws MatlabException {
        String cmd = model.isFollowLinks() ? FIND_SYSTEM_BLOCKS_WITH_REFS : FIND_SYSTEM_BLOCKS;
        return SimulinkUtil.getSimulinkBlocks(model, engine, engine.evalWithResult(cmd, model.getSimulinkModelName())).stream().map(e -> e).collect(Collectors.toList());
    }

    public static List<ISimulinkModelElement> getAllSimulinkLinesFromModel(SimulinkModel model, MatlabEngine engine) throws MatlabException {
        String cmd = model.isFollowLinks() ? FIND_SYSTEM_LINES_WITH_REFS : FIND_SYSTEM_LINES;
        return SimulinkUtil.getSimulinkLines(model, engine, engine.evalWithResult(cmd, model.getSimulinkModelName())).stream().map(e -> e).collect(Collectors.toList());
    }

    public static List<ISimulinkModelElement> getAllSimulinkBlocksFromModel(SimulinkModel model, MatlabEngine engine, String type) throws MatlabException {
        String simpleType = type;
        String cmd = model.isFollowLinks() ? FIND_BLOCKS_OF_TYPE_WITH_REFS : FIND_BLOCKS_OF_TYPE;
        Object blocks = engine.evalWithResult(cmd, model.getSimulinkModelName(), simpleType);
        return SimulinkUtil.getSimulinkBlocks(model, engine, blocks).stream().map(e -> e).collect(Collectors.toList());
    }
}

