/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.engine;

public class MatlabEngineCommands {
    public static final String ASSIGN = "? = ?";
    public static final String INSPECT = "inspect(?);";
    public static final String HANDLE = "handle = ?;";
    public static final String HANDLES = "handles = ";
    public static final String INSPECT_HANDLE = "inspect(handle);";
    public static final String GET_HANDLE_PROPERTY = "get_param(handle, '?');";
    public static final String GET_PROPERTY = "get_param(?, '?');";
    public static final String SET_HANDLE_PROPERTY = "set_param(handle, '?', '?');";
    public static final String SET_PROPERTY = "set_param(?, '?', '?');";
    public static final String LINE_BREAK = "\n";
    public static final String COMMAND_END = ";";
    public static final String SEP = " ";
    public static final String HANDLE_INSPECT_HANDLE = "handle = ?;inspect(handle);";
    public static final String GET_PROPERTY_FROM_HANDLE = "handle = ?;get_param(handle, '?');";
    public static final String SET_PROPERTY_TO_HANDLE = "handle = ?;set_param(handle, '?', '?');";
    private static final int SILENT = 0;
    private static final int DEBUG = 1;

    protected static String chain(String[] commands, int mode) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String sep = SEP;
            switch (mode) {
                case 0: {
                    sep = COMMAND_END;
                }
                case 1: {
                    sep = LINE_BREAK;
                }
            }
            builder.append(String.valueOf(s) + sep);
            ++n2;
        }
        return builder.toString();
    }

    public static String simulinkHandle(String cmd, String handle, Object ... params) {
        if (handle == null || handle.isEmpty()) {
            handle = "handle";
        }
        String c = String.valueOf(cmd) + "(" + handle;
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object parameter = objectArray[n2];
            c = String.valueOf(c) + ", '" + String.valueOf(parameter).replace("'", "''") + "'";
            ++n2;
        }
        return String.valueOf(c) + ")";
    }

    public static String simulink(String cmd, Object ... params) {
        return MatlabEngineCommands.simulinkHandle(cmd, "handle", params);
    }

    public static String cmd(String cmd, Object ... args) {
        return String.format(cmd, args);
    }
}

