/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.util.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TransformKey
implements Comparable<TransformKey> {
    private final ElementKey<?, ?> parent;
    private final MetadataKey<?> key;
    private final MetadataContext context;

    static TransformKey forParent(ElementKey<?, ?> parent, MetadataKey<?> key) {
        return TransformKey.forTransform(parent, key, null);
    }

    static TransformKey forKey(MetadataKey<?> key) {
        return TransformKey.forTransform(null, key, null);
    }

    static TransformKey forContext(MetadataKey<?> key, MetadataContext context) {
        return TransformKey.forTransform(null, key, context);
    }

    static TransformKey forTransform(ElementKey<?, ?> parent, MetadataKey<?> key, MetadataContext context) {
        Preconditions.checkNotNull(key, "key");
        return new TransformKey(parent, key, context);
    }

    private TransformKey(ElementKey<?, ?> parent, MetadataKey<?> key, MetadataContext context) {
        this.parent = parent;
        this.key = key;
        this.context = context;
    }

    boolean matches(TransformKey other) {
        return !(this.parent != null && !this.parent.matches(other.parent) || !this.key.matches(other.key) || this.context != null && !this.context.matches(other.context));
    }

    TransformKey bind(TransformKey other) {
        if (other == null) {
            return this;
        }
        ElementKey<?, ?> otherParent = other.getParent();
        MetadataKey<?> otherKey = other.getKey();
        MetadataContext otherContext = other.getContext();
        if (otherParent == this.parent && otherKey == this.key && (otherContext != null && otherContext.equals(this.context) || otherContext == null && this.context == null)) {
            return this;
        }
        return new TransformKey(otherParent != null ? otherParent : this.parent, otherKey != null ? otherKey : this.key, otherContext != null ? otherContext : this.context);
    }

    ElementKey<?, ?> getParent() {
        return this.parent;
    }

    MetadataKey<?> getKey() {
        return this.key;
    }

    MetadataContext getContext() {
        return this.context;
    }

    @Override
    public int compareTo(TransformKey other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        int compare = TransformKey.compare(this.parent, other.parent);
        if (compare != 0) {
            return compare;
        }
        compare = TransformKey.compare(this.key, other.key);
        if (compare != 0) {
            return compare;
        }
        if (this.context == null) {
            if (other.context != null) {
                compare = -1;
            }
        } else {
            compare = other.context == null ? 1 : this.context.compareTo(other.context);
        }
        return compare;
    }

    static int compare(MetadataKey<?> a, MetadataKey<?> b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public int hashCode() {
        int hash = this.key.hashCode();
        hash *= 17;
        if (this.parent != null) {
            hash += this.parent.hashCode();
        }
        hash *= 17;
        if (this.context != null) {
            hash += this.context.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TransformKey)) {
            return false;
        }
        TransformKey other = (TransformKey)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (!this.key.equals(other.key)) {
            return false;
        }
        return !(this.context == null ? other.context != null : !this.context.equals(other.context));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{TransformKey(");
        sb.append(this.parent == null ? "null" : this.parent);
        sb.append(',');
        sb.append(this.key == null ? "null" : this.key);
        sb.append(',');
        sb.append(this.context);
        sb.append(")}");
        return sb.toString();
    }
}

