/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.index.RowIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.PageStore;
import org.h2.store.Record;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageScanIndex
extends BaseIndex
implements RowIndex {
    private PageStore store;
    private TableData tableData;
    private final int headPos;
    private int lastKey;
    private long rowCount;
    private HashSet<Row> delta;
    private int rowCountDiff;
    private HashMap<Integer, Integer> sessionRowCount;

    public PageScanIndex(TableData tableData, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, Session session) throws SQLException {
        this.initBaseIndex(tableData, n, tableData.getName() + "_TABLE_SCAN", indexColumnArray, indexType);
        if (this.database.isMultiVersion()) {
            this.sessionRowCount = New.hashMap();
            this.isMultiVersion = true;
        }
        this.tableData = tableData;
        this.store = this.database.getPageStore();
        if (!this.database.isPersistent()) {
            this.headPos = 0;
            throw Message.throwInternalError(tableData.getName());
        }
        if (n2 == -1) {
            this.headPos = n2 = this.store.allocatePage();
            this.store.addMeta(this, session, n2);
            PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n2, 0, this.store.createData());
            this.store.updateRecord(pageDataLeaf, true, pageDataLeaf.data);
        } else {
            this.headPos = n2;
            PageData pageData = this.getPage(n2, 0);
            this.lastKey = pageData.getLastKey();
            this.rowCount = pageData.getRowCount();
            if (!this.database.isReadOnly()) {
                this.store.updateRecord(pageData, false, null);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened " + this.getName() + " rows:" + this.rowCount);
        }
        tableData.setRowCount(this.rowCount);
    }

    @Override
    public int getHeadPos() {
        return this.headPos;
    }

    @Override
    public void add(Session session, Row row) throws SQLException {
        PageData pageData;
        int n;
        if (row.getPos() == 0) {
            row.setPos(++this.lastKey);
        } else {
            this.lastKey = Math.max(this.lastKey, row.getPos() + 1);
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("add table:" + this.table.getId() + " " + row);
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                Value value2 = value.link(this.database, this.getId());
                if (value2.isLinked()) {
                    session.unlinkAtCommitStop(value2);
                }
                if (value == value2) continue;
                row.setValue(i, value2);
            }
        }
        while ((n = (pageData = this.getPage(this.headPos, 0)).addRowTry(row)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split " + n);
            }
            int n2 = n == 0 ? row.getPos() : pageData.getKey(n - 1);
            PageData pageData2 = pageData;
            PageData pageData3 = pageData.split(n);
            int n3 = pageData.getPos();
            int n4 = this.store.allocatePage();
            pageData2.setPageId(n4);
            pageData2.setParentPageId(this.headPos);
            pageData3.setParentPageId(this.headPos);
            PageDataNode pageDataNode = new PageDataNode(this, n3, 0, this.store.createData());
            pageDataNode.init(pageData2, n2, pageData3);
            this.store.updateRecord(pageData2, true, pageData2.data);
            this.store.updateRecord(pageData3, true, pageData3.data);
            this.store.updateRecord(pageDataNode, true, null);
            pageData = pageDataNode;
        }
        row.setDeleted(false);
        if (this.database.isMultiVersion()) {
            boolean bl;
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if (!(bl = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), 1);
        }
        this.invalidateRowCount();
        ++this.rowCount;
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, true);
    }

    PageDataOverflow getPageOverflow(int n, PageDataLeaf pageDataLeaf, int n2) throws SQLException {
        Record record = this.store.getRecord(n);
        if (record != null) {
            return (PageDataOverflow)record;
        }
        Data data = this.store.readPage(n);
        data.reset();
        PageDataOverflow pageDataOverflow = new PageDataOverflow(pageDataLeaf, n, data, n2);
        pageDataOverflow.read();
        return pageDataOverflow;
    }

    PageData getPage(int n, int n2) throws SQLException {
        PageData pageData;
        Record record = this.store.getRecord(n);
        if (record != null) {
            if (SysProperties.CHECK) {
                PageData pageData2 = (PageData)record;
                if (pageData2.index.headPos != this.headPos) {
                    throw Message.throwInternalError("Wrong index: " + pageData2.index.getName() + ":" + pageData2.index.headPos + " " + this.getName() + ":" + this.headPos);
                }
            }
            return (PageData)record;
        }
        Data data = this.store.readPage(n);
        data.reset();
        int n3 = data.readInt();
        int n4 = data.readByte() & 0xFF;
        switch (n4 & 0xFFFFFFEF) {
            case 1: {
                pageData = new PageDataLeaf(this, n, n3, data);
                break;
            }
            case 2: {
                pageData = new PageDataNode(this, n, n3, data);
                break;
            }
            case 0: {
                PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n, n3, data);
                return pageDataLeaf;
            }
            default: {
                throw Message.getSQLException(90030, "page=" + n + " type=" + n4);
            }
        }
        pageData.read();
        if (n2 != -1 && pageData.getParentPageId() != n2) {
            throw Message.throwInternalError(pageData + " parent " + pageData.getParentPageId() + " expected " + n2);
        }
        return pageData;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        PageData pageData = this.getPage(this.headPos, 0);
        return pageData.find(session);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("PAGE");
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        long l = 10L * (this.tableData.getRowCountApproximation() + 1000L);
        return l;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) throws SQLException {
        Object object;
        int n;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove " + row.getPos());
        }
        if (this.tableData.getContainsLargeObject()) {
            for (n = 0; n < row.getColumnCount(); ++n) {
                object = row.getValue(n);
                if (!((Value)object).isLinked()) continue;
                session.unlinkAtCommit((ValueLob)object);
            }
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            n = row.getPos();
            object = this.getPage(this.headPos, 0);
            ((PageData)object).remove(n);
            this.invalidateRowCount();
            --this.rowCount;
        }
        if (this.database.isMultiVersion()) {
            row.setDeleted(true);
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if ((n = (int)(this.delta.remove(row) ? 1 : 0)) == 0) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), -1);
        }
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, false);
    }

    private void invalidateRowCount() throws SQLException {
        PageData pageData = this.getPage(this.headPos, 0);
        pageData.setRowCountStored(-1);
    }

    @Override
    public void remove(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.removeAllRows();
        this.store.freePage(this.headPos, false, null);
        this.store.removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        if (this.database.isMultiVersion()) {
            this.sessionRowCount.clear();
        }
        this.tableData.setRowCount(0L);
    }

    private void removeAllRows() throws SQLException {
        PageData pageData = this.getPage(this.headPos, 0);
        pageData.freeChildren();
        pageData = new PageDataLeaf(this, this.headPos, 0, this.store.createData());
        this.store.removeRecord(this.headPos);
        this.store.updateRecord(pageData, true, null);
        this.rowCount = 0L;
        this.lastKey = 0;
    }

    @Override
    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("PAGE");
    }

    @Override
    public Row getRow(Session session, int n) throws SQLException {
        PageData pageData = this.getPage(this.headPos, 0);
        return pageData.getRow(n);
    }

    PageStore getPageStore() {
        return this.store;
    }

    Row readRow(Data data) throws SQLException {
        return this.tableData.readRow(data);
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            Integer n = this.sessionRowCount.get(session.getId());
            long l = n == null ? 0L : (long)n.intValue();
            l += this.rowCount;
            return l -= (long)this.rowCountDiff;
        }
        return this.rowCount;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public void close(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
        if (this.delta != null) {
            this.delta.clear();
        }
        this.rowCountDiff = 0;
        if (this.sessionRowCount != null) {
            this.sessionRowCount.clear();
        }
        PageData pageData = this.getPage(this.headPos, 0);
        pageData.setRowCountStored(MathUtils.convertLongToInt(this.rowCount));
    }

    Iterator<Row> getDelta() {
        if (this.delta == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.delta.iterator();
    }

    private void incrementRowCount(int n, int n2) {
        if (this.database.isMultiVersion()) {
            Integer n3 = n;
            Integer n4 = this.sessionRowCount.get(n3);
            int n5 = n4 == null ? 0 : n4;
            this.sessionRowCount.put(n3, n5 + n2);
            this.rowCountDiff += n2;
        }
    }

    @Override
    public void commit(int n, Row row) {
        if (this.database.isMultiVersion()) {
            if (this.delta != null) {
                this.delta.remove(row);
            }
            this.incrementRowCount(row.getSessionId(), n == 1 ? 1 : -1);
        }
    }
}

