/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IPerson;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Person
extends ExtensionPoint
implements IPerson {
    protected String name;
    protected String nameLang;
    protected String uri;
    protected String email;

    public Person() {
    }

    public Person(String name) {
        if (name == null) {
            throw new NullPointerException("Name must have a value");
        }
        this.name = name;
    }

    public Person(String name, String uri, String email) {
        this(name);
        this.uri = uri;
        this.email = email;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    @Override
    public String getNameLang() {
        return this.nameLang;
    }

    public void setNameLang(String v) {
        this.nameLang = v;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String v) {
        this.uri = v;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String v) {
        this.email = v;
    }

    public void generate(ExtensionProfile extProfile, XmlWriter w, XmlNamespace elementNamespace, String elementName, Collection<XmlWriter.Attribute> attributes) throws IOException {
        this.generateStartElement(w, elementNamespace, elementName, attributes, null);
        if (this.name != null && this.name.trim().length() > 0) {
            ArrayList<XmlWriter.Attribute> attrs;
            if (this.nameLang != null) {
                attrs = new ArrayList<XmlWriter.Attribute>(1);
                attrs.add(new XmlWriter.Attribute("xml:lang", this.nameLang));
            } else {
                attrs = null;
            }
            w.simpleElement(Namespaces.atomNs, "name", attrs, this.name);
        }
        if (this.uri != null && this.uri.trim().length() > 0) {
            w.simpleElement(Namespaces.atomNs, "uri", null, this.uri);
        }
        if (this.email != null && this.email.trim().length() > 0) {
            w.simpleElement(Namespaces.atomNs, "email", null, this.email);
        }
        this.generateExtensions(w, extProfile);
        w.endElement(elementNamespace, elementName);
    }

    @Override
    protected void generate(XmlWriter w, ExtensionProfile p, XmlNamespace namespace, String localName, List<XmlWriter.Attribute> attrs, AttributeGenerator generator) throws IOException {
        this.generate(p, w, namespace, localName, attrs);
    }

    public void generateAtom(ExtensionProfile extProfile, XmlWriter w, String elementName) throws IOException {
        this.generate(extProfile, w, Namespaces.atomNs, elementName, null);
    }

    public void generateRss(XmlWriter w, String elementName) throws IOException {
        String text = new String();
        if (this.email != null) {
            text = text + this.email;
        }
        if (this.name != null) {
            if (this.email != null) {
                text = text + " (";
            }
            text = text + this.name;
            if (this.email != null) {
                text = text + ")";
            }
        }
        w.simpleElement(Namespaces.rssNs, elementName, null, text);
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new AtomHandler(extProfile);
    }

    public class AtomHandler
    extends ExtensionPoint.ExtensionHandler {
        public AtomHandler(ExtensionProfile extProfile) {
            super(Person.this, extProfile, Person.this.getClass());
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://www.w3.org/2005/Atom")) {
                if (localName.equals("name")) {
                    return new NameHandler();
                }
                if (localName.equals("uri")) {
                    return new UriHandler();
                }
                if (localName.equals("email")) {
                    return new EmailHandler();
                }
            } else {
                return super.getChildHandler(namespace, localName, attrs);
            }
            return null;
        }

        class EmailHandler
        extends XmlParser.ElementHandler {
            EmailHandler() {
            }

            public void processEndElement() throws ParseException {
                if (Person.this.email != null) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateEmail);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.emailValueRequired);
                }
                Person.this.email = this.value;
            }
        }

        class UriHandler
        extends XmlParser.ElementHandler {
            UriHandler() {
            }

            public void processEndElement() throws ParseException {
                if (Person.this.uri != null) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateUri);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.uriValueRequired);
                }
                Person.this.uri = this.value;
            }
        }

        class NameHandler
        extends XmlParser.ElementHandler {
            NameHandler() {
            }

            public void processEndElement() throws ParseException {
                if (Person.this.name != null) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateName);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.nameValueRequired);
                }
                Person.this.name = this.value;
                Person.this.nameLang = this.xmlLang;
            }
        }
    }
}

