/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.transaction;

import java.util.Map;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.base.block.BlockMgr;
import org.apache.jena.tdb1.base.block.BlockMgrReadonly;
import org.apache.jena.tdb1.base.file.FileSet;
import org.apache.jena.tdb1.base.objectfile.ObjectFile;
import org.apache.jena.tdb1.base.objectfile.ObjectFileReadonly;
import org.apache.jena.tdb1.index.IndexParams;
import org.apache.jena.tdb1.setup.BlockMgrBuilder;
import org.apache.jena.tdb1.setup.DatasetBuilderStd;
import org.apache.jena.tdb1.setup.ObjectFileBuilder;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.sys.FileRef;
import org.apache.jena.tdb1.transaction.BlockMgrJournal;
import org.apache.jena.tdb1.transaction.DatasetGraphTxn;
import org.apache.jena.tdb1.transaction.ObjectFileTrans;
import org.apache.jena.tdb1.transaction.Transaction;
import org.apache.jena.tdb1.transaction.TransactionManager;

public class DatasetBuilderTxn {
    private final TransactionManager txnMgr;
    private final Map<FileRef, BlockMgr> blockMgrs;
    private final Map<FileRef, ObjectFile> objectFiles;
    private final DatasetGraphTDB dsg;
    private Transaction txn;

    public DatasetBuilderTxn(TransactionManager txnMgr, DatasetGraphTDB dsg) {
        this.txnMgr = txnMgr;
        this.blockMgrs = dsg.getConfig().blockMgrs;
        this.objectFiles = dsg.getConfig().objectFiles;
        this.dsg = dsg;
    }

    DatasetGraphTxn build(Transaction txn, ReadWrite mode) {
        this.txn = txn;
        DatasetGraphTxn dsgTxn = new DatasetGraphTxn(switch (mode) {
            case ReadWrite.READ -> this.buildReadonly();
            case ReadWrite.WRITE -> this.buildWritable();
            default -> null;
        }, txn);
        dsgTxn.getContext().putAll(this.dsg.getContext());
        return dsgTxn;
    }

    private DatasetGraphTDB buildReadonly() {
        BlockMgrBuilderReadonly blockMgrBuilder = new BlockMgrBuilderReadonly();
        ObjectFileBuilderReadonly objectFileBuilder = new ObjectFileBuilderReadonly();
        DatasetBuilderStd x = new DatasetBuilderStd(blockMgrBuilder, objectFileBuilder);
        DatasetGraphTDB dsg2 = x._build(this.dsg.getLocation(), this.dsg.getConfig().params, false, this.dsg.getReorderTransform());
        return dsg2;
    }

    private DatasetGraphTDB buildWritable() {
        BlockMgrBuilderTx blockMgrBuilder = new BlockMgrBuilderTx();
        ObjectFileBuilderTx objectFileBuilder = new ObjectFileBuilderTx();
        DatasetBuilderStd x = new DatasetBuilderStd(blockMgrBuilder, objectFileBuilder);
        DatasetGraphTDB dsg2 = x._build(this.dsg.getLocation(), this.dsg.getConfig().params, true, this.dsg.getReorderTransform());
        dsg2.getContext().putAll(this.dsg.getContext());
        return dsg2;
    }

    class BlockMgrBuilderReadonly
    implements BlockMgrBuilder {
        BlockMgrBuilderReadonly() {
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, IndexParams params) {
            FileRef ref = FileRef.create(fileSet, ext);
            BlockMgr blockMgr = DatasetBuilderTxn.this.blockMgrs.get(ref);
            if (blockMgr == null) {
                throw new TDB1Exception("No BlockMgr for " + ref);
            }
            blockMgr = new BlockMgrReadonly(blockMgr);
            return blockMgr;
        }
    }

    class ObjectFileBuilderReadonly
    implements ObjectFileBuilder {
        ObjectFileBuilderReadonly() {
        }

        @Override
        public ObjectFile buildObjectFile(FileSet fileSet, String ext) {
            FileRef ref = FileRef.create(fileSet, ext);
            ObjectFile file = DatasetBuilderTxn.this.objectFiles.get(ref);
            return new ObjectFileReadonly(file);
        }
    }

    class BlockMgrBuilderTx
    implements BlockMgrBuilder {
        BlockMgrBuilderTx() {
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, IndexParams params) {
            FileRef ref = FileRef.create(fileSet, ext);
            BlockMgr baseMgr = DatasetBuilderTxn.this.blockMgrs.get(ref);
            if (baseMgr == null) {
                System.out.println("No BlockMgr for " + ref + " : " + DatasetBuilderTxn.this.blockMgrs.keySet());
            }
            BlockMgrJournal blkMgr = new BlockMgrJournal(DatasetBuilderTxn.this.txn, ref, baseMgr);
            DatasetBuilderTxn.this.txn.addComponent(blkMgr);
            return blkMgr;
        }
    }

    class ObjectFileBuilderTx
    implements ObjectFileBuilder {
        ObjectFileBuilderTx() {
        }

        @Override
        public ObjectFile buildObjectFile(FileSet fileSet, String ext) {
            FileRef ref = FileRef.create(fileSet, ext);
            ObjectFile base = DatasetBuilderTxn.this.objectFiles.get(ref);
            ObjectFileTrans objFileTxn = new ObjectFileTrans(DatasetBuilderTxn.this.txn, base);
            DatasetBuilderTxn.this.txn.addComponent(objFileTxn);
            return objFileTxn;
        }
    }
}

