/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lib;

import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonNull;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.expr.NodeValue;

public class RDFTerm2Json {
    public static JsonValue fromNode(Node node) {
        if (node == null) {
            return JsonNull.instance;
        }
        if (node.isURI()) {
            return new JsonString(node.getURI());
        }
        if (node.isBlank()) {
            Node node2 = RiotLib.blankNodeToIri(node);
            return new JsonString(node2.getURI());
        }
        if (node.isVariable()) {
            return new JsonString("?" + node.getName());
        }
        if (Util.isSimpleString(node) || Util.isLangString(node)) {
            return new JsonString(node.getLiteralLexicalForm());
        }
        RDFDatatype dt = node.getLiteralDatatype();
        NodeValue nv = NodeValue.makeNode(node);
        if (nv.isNumber()) {
            if (nv.isInteger()) {
                try {
                    return JsonNumber.value(nv.getInteger().longValueExact());
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            if (nv.isDecimal()) {
                return JsonNumber.value(nv.getDecimal());
            }
            if (nv.isDouble()) {
                return JsonNumber.value(nv.getDouble());
            }
            if (nv.isFloat()) {
                return JsonNumber.value(nv.getFloat());
            }
        } else if (nv.isBoolean()) {
            return new JsonBoolean(nv.getBoolean());
        }
        return new JsonString(node.getLiteralLexicalForm());
    }
}

