/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.repositories;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.GraphMaker;
import org.apache.jena.ontapi.GraphRepository;
import org.apache.jena.ontapi.UnionGraph;
import org.apache.jena.ontapi.utils.Graphs;

public class PersistentGraphRepository
implements GraphRepository {
    protected final GraphMaker source;
    protected final Map<String, Graph> graphs;

    public PersistentGraphRepository(GraphMaker source) {
        this.source = Objects.requireNonNull(source);
        this.graphs = PersistentGraphRepository.loadGraphs(source);
    }

    protected static Map<String, Graph> loadGraphs(GraphMaker source) {
        HashMap<String, Graph> res = new HashMap<String, Graph>();
        source.names().forEach(id -> {
            Graph g = source.openGraph((String)id);
            String name = Graphs.findOntologyNameNode(g).map(Node::toString).orElse((String)id);
            res.put(name, g);
        });
        return res;
    }

    public GraphMaker getGraphMaker() {
        return this.source;
    }

    @Override
    public Graph get(String id) {
        return this.graphs.computeIfAbsent(id, this.source::openGraph);
    }

    @Override
    public Graph put(String id, Graph graph) {
        Set graphs = this.source.graphs().collect(Collectors.toSet());
        if (graph instanceof UnionGraph) {
            if (Graphs.dataGraphs(graph).anyMatch(it -> !graphs.contains(it))) {
                throw new IllegalArgumentException("Operation 'put' is not supported for the given UnionGraph (id = " + id + "):it contains subgraphs that do not managed by the underlying storage");
            }
        } else if (!graphs.contains(graph)) {
            throw new IllegalArgumentException("Operation 'put' is not supported for the given Graph (id = " + id + "):it does not managed by the underlying storage");
        }
        Optional<Map.Entry> prev = this.graphs.entrySet().stream().filter(it -> graph.equals(it.getValue())).findFirst();
        prev.map(Map.Entry::getKey).ifPresent(this.graphs::remove);
        this.graphs.put(id, graph);
        return prev.map(Map.Entry::getValue).orElse(null);
    }

    @Override
    public Graph remove(String id) {
        return this.graphs.remove(id);
    }

    @Override
    public void clear() {
        this.graphs.clear();
    }

    @Override
    public Stream<String> ids() {
        return this.graphs.keySet().stream();
    }

    @Override
    public Stream<Graph> graphs() {
        return this.graphs.values().stream();
    }

    @Override
    public boolean contains(String id) {
        return this.graphs.containsKey(id) || this.source.hasGraph(id);
    }
}

