/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.configuration;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.handler.ESChecksumErrorHandler;
import org.eclipse.emf.emfstore.client.handler.ESOperationModifier;
import org.eclipse.emf.emfstore.client.provider.ESClientConfigurationProvider;
import org.eclipse.emf.emfstore.client.util.ESCopier;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.DefaultCopier;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.ChecksumErrorHandler;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Behavior {
    public static final long NO_CHECKSUM = -1L;
    public static final String RESOURCE_OPTIONS_EXTENSION_POINT_NAME = "org.eclipse.emf.emfstore.client.changeRecordingOptions";
    public static final String AUTO_SAVE_EXTENSION_POINT_ATTRIBUTE_NAME = "autoSave";
    public static final String RERECORD_LOCAL_CHANGES_EXTENSION_POINT_ATTRIBUTE_NAME = "rerecordLocalChanges";
    public static final String CUT_OFF_INCOMING_CROSS_REFS_EXTENSION_POINT_ATTRIBUTE_NAME = "cutOffIncomingCrossReferences";
    public static final String FORCE_COMMANDS_EXTENSION_POINT_ATTRIBUTE_NAME = "forceCommands";
    public static final String DENY_ADD_CUT_ELEMENTS_TO_MODELELEMENTS_FEATURE_EXTENSION_POINT_ATTRIBUTE_NAME = "denyAddCutElementsToModelElements";
    public static final String USE_IN_MEMORY_CHANGE_PACKAGE = "useInMemoryChangePackage";
    public static final String CHANGEPACKAGE_FRAGMENT_SIZE = "changePackageFragmentationSize";
    public static final String OPERATION_MODIFIER = "operationModifier";
    public static final String COPIER = "copier";
    private static Boolean isAutoSaveActive;
    private static Boolean isRerecordingActive;
    private static Boolean isCutOffIncomingCrossReferencesActive;
    private static Boolean isForceCommandsActive;
    private static Boolean isDenyAddCutElementsToModelElementsFeatureActive;
    private static Boolean isUseMemoryChangePackageActive;
    private static Optional<Integer> changePackageFragmentSize;
    private static ESOperationModifier operationModifier;
    private static List<ESCopier> copierList;
    private ESChecksumErrorHandler checksumErrorHandler;

    public void setAutoSave(boolean enabled) {
        isAutoSaveActive = enabled;
    }

    public boolean isAutoSaveEnabled() {
        if (isAutoSaveActive == null) {
            isAutoSaveActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(AUTO_SAVE_EXTENSION_POINT_ATTRIBUTE_NAME, false);
        }
        return isAutoSaveActive;
    }

    public Boolean isRerecordingActivated() {
        if (isRerecordingActive == null) {
            isRerecordingActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(RERECORD_LOCAL_CHANGES_EXTENSION_POINT_ATTRIBUTE_NAME, Boolean.TRUE.booleanValue());
        }
        return isRerecordingActive;
    }

    public Boolean isCutOffIncomingCrossReferencesActivated() {
        if (isCutOffIncomingCrossReferencesActive == null) {
            isCutOffIncomingCrossReferencesActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(CUT_OFF_INCOMING_CROSS_REFS_EXTENSION_POINT_ATTRIBUTE_NAME, Boolean.TRUE.booleanValue());
        }
        return isCutOffIncomingCrossReferencesActive;
    }

    public Boolean isForceCommandsActived() {
        if (isForceCommandsActive == null) {
            isForceCommandsActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(FORCE_COMMANDS_EXTENSION_POINT_ATTRIBUTE_NAME, Boolean.FALSE.booleanValue());
        }
        return isForceCommandsActive;
    }

    public Boolean isDenyAddCutElementsToModelElementsFeatureActived() {
        if (isDenyAddCutElementsToModelElementsFeatureActive == null) {
            isDenyAddCutElementsToModelElementsFeatureActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(DENY_ADD_CUT_ELEMENTS_TO_MODELELEMENTS_FEATURE_EXTENSION_POINT_ATTRIBUTE_NAME, Boolean.FALSE.booleanValue());
        }
        return isDenyAddCutElementsToModelElementsFeatureActive;
    }

    public boolean isChecksumCheckActive() {
        ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.client.checksumErrorHandler");
        return extensionPoint.getBoolean("isActive", true);
    }

    public ESChecksumErrorHandler getChecksumErrorHandler() {
        if (this.checksumErrorHandler == null) {
            ESChecksumErrorHandler errorHandler;
            ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.client.checksumErrorHandler");
            ESExtensionElement elementWithHighestPriority = extensionPoint.getElementWithHighestPriority();
            if (elementWithHighestPriority != null && (errorHandler = (ESChecksumErrorHandler)elementWithHighestPriority.getClass("errorHandler", ESChecksumErrorHandler.class)) != null) {
                this.checksumErrorHandler = errorHandler;
            }
            if (this.checksumErrorHandler == null) {
                this.checksumErrorHandler = ChecksumErrorHandler.CANCEL;
            }
        }
        return this.checksumErrorHandler;
    }

    public void setChecksumErrorHandler(ESChecksumErrorHandler errorHandler) {
        this.checksumErrorHandler = errorHandler;
    }

    public boolean useInMemoryChangePackage() {
        if (isUseMemoryChangePackageActive == null) {
            ESExtensionPoint extensionPoint = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).setThrowException(true);
            try {
                isUseMemoryChangePackageActive = extensionPoint.getBoolean(USE_IN_MEMORY_CHANGE_PACKAGE, false);
            }
            catch (ESExtensionPointException eSExtensionPointException) {
                isUseMemoryChangePackageActive = Boolean.getBoolean("emfstore.inMemoryChangePackage");
            }
        }
        return isUseMemoryChangePackageActive;
    }

    public Optional<Integer> getChangePackageFragmentSize() {
        if (changePackageFragmentSize == null) {
            Integer fragmentSize = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getInteger(CHANGEPACKAGE_FRAGMENT_SIZE);
            changePackageFragmentSize = fragmentSize == null ? Optional.absent() : Optional.of((Object)fragmentSize);
        }
        return changePackageFragmentSize;
    }

    public ESOperationModifier getOperationModifier() {
        if (operationModifier == null) {
            ESOperationModifier modifier = (ESOperationModifier)new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getClass(OPERATION_MODIFIER, ESOperationModifier.class);
            operationModifier = modifier == null ? new ESOperationModifier(){

                @Override
                public List<AbstractOperation> modify(List<AbstractOperation> operations, Command command) {
                    return operations;
                }
            } : modifier;
        }
        return operationModifier;
    }

    public ESCopier getESCopierFor(EObject eObject) {
        if (copierList == null) {
            copierList = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getClasses(COPIER, ESCopier.class);
        }
        ESCopier selectedCopier = new DefaultCopier();
        for (ESCopier copier : copierList) {
            if (copier.shouldHandle(eObject) <= -1) continue;
            selectedCopier = copier;
        }
        return selectedCopier;
    }

    public void setChangePackageFragmentSize(Optional<Integer> fragmentSize) {
        changePackageFragmentSize = fragmentSize;
    }

    public List<ServerInfo> getDefaultServerInfos() {
        ESClientConfigurationProvider provider = (ESClientConfigurationProvider)new ESExtensionPoint("org.eclipse.emf.emfstore.client.defaultConfigurationProvider").getClass("providerClass", ESClientConfigurationProvider.class);
        ArrayList<ServerInfo> result = new ArrayList<ServerInfo>();
        if (provider != null) {
            List<ESServer> defaultServerInfos = provider.getDefaultServerInfos();
            for (ESServer server : defaultServerInfos) {
                result.add((ServerInfo)((ESServerImpl)server).toInternalAPI());
            }
            return result;
        }
        result.add(this.getLocalhostServerInfo());
        return result;
    }

    private ServerInfo getLocalhostServerInfo() {
        ServerInfo serverInfo = ModelFactory.eINSTANCE.createServerInfo();
        serverInfo.setName("Localhost Server");
        serverInfo.setPort(8080);
        serverInfo.setUrl("localhost");
        serverInfo.setCertificateAlias("emfstore test certificate (do not use in production!)");
        Usersession superUsersession = ModelFactory.eINSTANCE.createUsersession();
        superUsersession.setServerInfo(serverInfo);
        superUsersession.setPassword("super");
        superUsersession.setSavePassword(true);
        superUsersession.setUsername("super");
        serverInfo.setLastUsersession(superUsersession);
        return serverInfo;
    }
}

