/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.mutation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.Mutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationPredicates;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationTargetSelector;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.StructuralFeatureMutation;
import org.eclipse.emf.emfstore.modelmutator.ESFeatureMapKeyMutation;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;
import org.eclipse.emf.emfstore.modelmutator.ESMutationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureMapKeyMutation
extends StructuralFeatureMutation<ESFeatureMapKeyMutation>
implements ESFeatureMapKeyMutation {
    public FeatureMapKeyMutation(ESModelMutatorUtil util) {
        super(util);
        this.addTargetFeaturePredicate();
        this.addOriginalFeatureValuePredicate();
    }

    public FeatureMapKeyMutation(ESModelMutatorUtil util, MutationTargetSelector selector) {
        super(util, selector);
        this.addTargetFeaturePredicate();
        this.addOriginalFeatureValuePredicate();
    }

    private void addTargetFeaturePredicate() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add(MutationPredicates.HAS_GROUP_FEATURE_MAP_ENTRY_TYPE);
    }

    private void addOriginalFeatureValuePredicate() {
        this.getTargetContainerSelector().getOriginalFeatureValuePredicates().add(MutationPredicates.IS_NON_EMPTY_FEATURE_MAP);
    }

    @Override
    public Mutation clone() {
        return new FeatureMapKeyMutation(this.getUtil(), this.getTargetContainerSelector());
    }

    @Override
    public void apply() throws ESMutationException {
        this.getTargetContainerSelector().doSelection();
        List<FeatureMap.Entry> currentEntries = this.getFeatureMapEntries();
        FeatureMap.Entry entry = this.getRandomFeatureMapEntryOfTarget(currentEntries);
        EStructuralFeature currentFeatureKey = entry.getEStructuralFeature();
        EStructuralFeature newFeatureKey = this.getRandomFeatureKeyExcludingCurrent(currentFeatureKey);
        FeatureMap.Entry newEntry = FeatureMapUtil.createEntry((EStructuralFeature)newFeatureKey, (Object)entry.getValue());
        if (FeatureMapKeyMutation.isMonoReference(currentFeatureKey)) {
            return;
        }
        if (!currentEntries.contains(newEntry)) {
            currentEntries.set(currentEntries.indexOf(entry), newEntry);
        }
    }

    private static boolean isMonoReference(EStructuralFeature feature) {
        return EReference.class.isInstance(feature) && !((EReference)EReference.class.cast(feature)).isMany();
    }

    private FeatureMap.Entry getRandomFeatureMapEntryOfTarget(List<FeatureMap.Entry> currentEntries) {
        int pickIndex = this.getRandom().nextInt(currentEntries.size());
        return currentEntries.get(pickIndex);
    }

    private List<FeatureMap.Entry> getFeatureMapEntries() {
        return (List)this.getTargetObject().eGet(this.getTargetFeature());
    }

    private EStructuralFeature getRandomFeatureKeyExcludingCurrent(EStructuralFeature currentFeatureKey) throws ESMutationException {
        List<EStructuralFeature> availableFeatures = this.getCompatibleFeatureKeys(currentFeatureKey);
        int pickIndex = this.getRandom().nextInt(availableFeatures.size());
        return availableFeatures.get(pickIndex);
    }

    private List<EStructuralFeature> getCompatibleFeatureKeys(EStructuralFeature currentFeatureKey) throws ESMutationException {
        ArrayList availableFeatures = Lists.newArrayList(this.getFeaturesOfFeatureMapGroup());
        this.filterIncompatibleFeatures(availableFeatures, currentFeatureKey);
        if (availableFeatures.isEmpty()) {
            throw new ESMutationException("Could not find compatible FeatureMapKey to swap.");
        }
        return availableFeatures;
    }

    private void filterIncompatibleFeatures(List<EStructuralFeature> availableFeatures, EStructuralFeature compatibleFeature) {
        availableFeatures.remove(compatibleFeature);
        for (EStructuralFeature feature : Lists.newArrayList(availableFeatures)) {
            if (this.isEqualOrSubclass(feature.getEType(), compatibleFeature.getEType())) continue;
            availableFeatures.remove(feature);
        }
    }

    private boolean isEqualOrSubclass(EClassifier eClassifier, EClassifier compatibleEClassifier) {
        if (eClassifier instanceof EClass && compatibleEClassifier instanceof EClass) {
            EClass compatibleEClass = (EClass)compatibleEClassifier;
            EClass eClass = (EClass)eClassifier;
            return compatibleEClass.equals(eClass) || compatibleEClass.isSuperTypeOf(eClass);
        }
        return compatibleEClassifier.equals(eClassifier);
    }

    public List<EStructuralFeature> getFeaturesOfFeatureMapGroup() {
        EStructuralFeature targetFeature = this.getTargetContainerSelector().getTargetFeature();
        List<EStructuralFeature> features = targetFeature != null ? this.getFeaturesOfFeatureMapGroup(targetFeature) : Collections.emptyList();
        return features;
    }

    private List<EStructuralFeature> getFeaturesOfFeatureMapGroup(EStructuralFeature featureMapGroup) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        EClass eClass = featureMapGroup.getEContainingClass();
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!this.isFeatureOfFeatureMapGroup(feature, featureMapGroup)) continue;
            features.add(feature);
        }
        return features;
    }

    private boolean isFeatureOfFeatureMapGroup(EStructuralFeature feature, EStructuralFeature featureMapGroupFeature) {
        String featureMapGroupFeatureName = featureMapGroupFeature.getName();
        String extendedMetaDataGroupName = this.getExtendedMetaDataGroupName(feature);
        return extendedMetaDataGroupName != null && ("#" + featureMapGroupFeatureName).equals(extendedMetaDataGroupName);
    }

    private String getExtendedMetaDataGroupName(EStructuralFeature feature) {
        EAnnotation eAnnotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        String extendedMetaDataGroupName = eAnnotation != null && eAnnotation.getDetails().get((Object)"group") != null ? (String)eAnnotation.getDetails().get((Object)"group") : null;
        return extendedMetaDataGroupName;
    }
}

