/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.changetracking.ESCommandObserver;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.NotificationRecorder;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationRecorder;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationRecorderConfig;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationRecorderListener;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.observers.OperationObserver;
import org.eclipse.emf.emfstore.internal.common.ESDisposable;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.semantic.SemanticCompositeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationManager
implements OperationRecorderListener,
ESDisposable,
ESCommandObserver,
IdEObjectCollectionChangeObserver {
    private final OperationRecorder operationRecorder;
    private final ProjectSpace projectSpace;

    public OperationManager(ProjectSpaceBase projectSpace) {
        this.operationRecorder = new OperationRecorder(projectSpace);
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this.operationRecorder);
        this.operationRecorder.addOperationRecorderListener(this);
        this.configureOperationRecorder();
        this.projectSpace = this.operationRecorder.getProjectSpace();
    }

    private void configureOperationRecorder() {
        OperationRecorderConfig config = this.operationRecorder.getConfig();
        config.setCutOffIncomingCrossReferences(Configuration.getClientBehavior().isCutOffIncomingCrossReferencesActivated());
        config.setForceCommands(Configuration.getClientBehavior().isForceCommandsActived());
        config.setDenyAddCutElementsToModelElements(Configuration.getClientBehavior().isDenyAddCutElementsToModelElementsFeatureActived());
        config.setOperationModifier(Configuration.getClientBehavior().getOperationModifier());
    }

    public void undoLastOperation() {
        this.projectSpace.undoLastOperations(1);
    }

    public void addOperationObserver(OperationObserver operationObserver) {
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)operationObserver);
    }

    public void removeOperationListener(OperationObserver operationObserver) {
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)operationObserver);
    }

    public void notifyOperationUndone(AbstractOperation operation) {
        ((OperationObserver)ESWorkspaceProviderImpl.getObserverBus().notify(OperationObserver.class)).operationUndone(operation);
    }

    void notifyOperationExecuted(AbstractOperation operation) {
        ((OperationObserver)ESWorkspaceProviderImpl.getObserverBus().notify(OperationObserver.class)).operationExecuted(operation);
    }

    public void abortCompositeOperation() {
        this.undoLastOperation();
        this.operationRecorder.abortCompositeOperation();
    }

    public void endCompositeOperation() {
        this.notifyOperationExecuted((AbstractOperation)this.operationRecorder.getCompositeOperation());
        this.operationRecorder.endCompositeOperation();
    }

    public void endCompositeOperation(SemanticCompositeOperation semanticCompositeOperation) {
        this.projectSpace.getLocalChangePackage().removeAtEnd(1);
        this.projectSpace.getLocalChangePackage().add((AbstractOperation)semanticCompositeOperation);
        this.endCompositeOperation();
    }

    public CompositeOperationHandle beginCompositeOperation() {
        return this.operationRecorder.beginCompositeOperation();
    }

    @Override
    public void operationsRecorded(List<? extends AbstractOperation> operations) {
        this.projectSpace.addOperations(operations);
    }

    public List<AbstractOperation> clearOperations() {
        return this.operationRecorder.clearOperations();
    }

    public void dispose() {
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this.operationRecorder);
        this.operationRecorder.removeOperationRecorderListener(this);
    }

    public NotificationRecorder getNotificationRecorder() {
        return this.operationRecorder.getNotificationRecorder();
    }

    @Override
    public void commandStarted(Command command) {
        this.operationRecorder.commandStarted(command);
    }

    @Override
    public void commandCompleted(Command command) {
        this.operationRecorder.commandCompleted(command);
    }

    @Override
    public void commandFailed(Command command, Exception exception) {
        this.operationRecorder.commandFailed(command, exception);
    }

    public void notify(Notification notification, IdEObjectCollection collection, EObject modelElement) {
        this.operationRecorder.notify(notification, collection, modelElement);
    }

    public void modelElementAdded(IdEObjectCollection collection, EObject modelElement) {
        this.operationRecorder.modelElementAdded(collection, modelElement);
    }

    public void modelElementRemoved(IdEObjectCollection collection, EObject modelElement) {
        this.operationRecorder.modelElementRemoved(collection, modelElement);
    }

    public void collectionDeleted(IdEObjectCollection collection) {
        this.operationRecorder.collectionDeleted(collection);
    }

    public void startChangeRecording() {
        this.operationRecorder.startChangeRecording();
    }

    public void stopChangeRecording() {
        this.operationRecorder.stopChangeRecording();
    }

    public OperationRecorderConfig getRecorderConfig() {
        return this.operationRecorder.getConfig();
    }

    public void commandCompleted(Command command, boolean isNestedCommand) {
        this.operationRecorder.commandCompleted(command, isNestedCommand);
    }

    public boolean isCommandRunning() {
        return this.operationRecorder.isCommandRunning();
    }
}

