/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.DefaultServerWorkspaceLocationProvider;
import org.eclipse.emf.emfstore.internal.server.Messages;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.PAPrivileges;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.AuthenticationControlType;
import org.eclipse.emf.emfstore.internal.server.startup.PostStartupListener;
import org.eclipse.emf.emfstore.internal.server.startup.StartupListener;
import org.eclipse.emf.emfstore.server.ESLocationProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerConfiguration {
    public static final String ES_PROPERTIES = "es.properties";
    private static final String CHECKSUM_KEY = "org.eclipse.emf.emfstore.server.computeChecksum";
    private static final String SERVER_BUNDLE_KEY = "org.eclipse.emf.emfstore.server";
    private static final String LOCATION_PROVIDER_KEY = "org.eclipse.emf.emfstore.server.locationProvider";
    public static final String RESOURCE_STORAGE = "emfstore.persistence.resourceStorage";
    public static final String RESOURCE_STORAGE_DEFAULT = "org.eclipse.emf.emfstore.internal.server.storage.XMLStorage";
    public static final String RMI_ENCRYPTION = "emfstore.connection.rmi.encryption";
    public static final String RMI_ENCRYPTION_DEFAULT = "true";
    public static final String XML_RPC_PORT = "emfstore.connection.xmlrpc.port";
    public static final String XML_RPC_PORT_DEFAULT = "8080";
    public static final String SERVER_KEYSTORE_FILE = "emfstoreServer.keystore";
    public static final String KEYSTORE_PASSWORD = "emfstore.keystore.password";
    public static final String KEYSTORE_PASSWORD_DEFAULT = "123456";
    public static final String KEYSTORE_ALIAS = "emfstore.keystore.alias";
    public static final String KEYSTORE_ALIAS_DEFAULT = "testkeygeneratedbyotto";
    public static final String KEYSTORE_CERTIFICATE_TYPE = "emfstore.keystore.certificate.type";
    public static final String KEYSTORE_CERTIFICATE_TYPE_DEFAULT = "SunX509";
    public static final String KEYSTORE_CIPHER_ALGORITHM = "emfstore.keystore.cipher.algorithm";
    public static final String KEYSTORE_CIPHER_ALGORITHM_DEFAULT = "RSA";
    public static final String PROJECTSTATE_VERSION_PERSISTENCE = "emfstore.persistence.version.projectstate";
    public static final String PROJECTSTATE_VERSION_PERSISTENCE_FIRSTANDLASTVERSIONONLY = "firstAndLastVersionOnly";
    public static final String PROJECTSTATE_VERSION_PERSISTENCE_EVERYXVERSIONS = "everyXVersion";
    public static final String PROJECTSTATE_VERSION_PERSISTENCE_EVERYXVERSIONS_X = "emfstore.persistence.version.projectstate.everyxversions";
    public static final String PROJECTSTATE_VERSION_PERSISTENCE_EVERYXVERSIONS_X_DEFAULT = "1";
    public static final String PROJECTSPACE_VERSION_PERSISTENCE_DEFAULT = "everyXVersion";
    public static final String SESSION_TIMEOUT = "emfstore.accesscontrol.session.timeout";
    public static final String SESSION_TIMEOUT_DEFAULT = "1800000";
    public static final String SUPER_USER = "emfstore.accesscontrol.authentication.superuser";
    public static final String SUPER_USER_DEFAULT = "super";
    public static final String SUPER_USER_PASSWORD = "emfstore.accesscontrol.authentication.superuser.password";
    public static final String SUPER_USER_PASSWORD_DEFAULT = "super";
    public static final String AUTHENTICATION_POLICY = "emfstore.accesscontrol.authentication.policy";
    public static final String AUTHENTICATION_LDAP_PREFIX = "emfstore.accesscontrol.authentication.ldap";
    public static final String AUTHENTICATION_LDAP_URL = "url";
    public static final String AUTHENTICATION_LDAP_AUTHUSER = "authuser";
    public static final String AUTHENTICATION_LDAP_AUTHPASS = "authpass";
    public static final String AUTHENTICATION_LDAP_BASE = "base";
    public static final String AUTHENTICATION_LDAP_SEARCHDN = "searchdn";
    public static final AuthenticationControlType AUTHENTICATION_POLICY_DEFAULT = AuthenticationControlType.spfv;
    public static final String AUTHENTICATION_SPFV_FILEPATH = "emfstore.accesscontrol.authentication.spfv";
    public static final String VALIDATION_PROJECT_EXCLUDE_DEFAULT = "";
    public static final String LOAD_STARTUP_LISTENER = "emfstore.startup.loadlistener";
    public static final String LOAD_POST_STARTUP_LISTENER = "emfstore.startup.post.loadlistener";
    public static final String LOAD_STARTUP_LISTENER_DEFAULT = Boolean.TRUE.toString();
    public static final String ACCEPTED_VERSIONS = "emfstore.acceptedversions";
    public static final String ACCEPTED_VERSIONS_ANY = "any";
    public static final String MULTI_PROPERTY_SEPERATOR = ",";
    public static final String EMFSTORE_HOME = "-EMFStoreHome";
    public static final String AUTHENTICATION_MATCH_USERS_IGNORE_CASE = "emfstore.accesscontrol.authentication.matchusers.ignorecase";
    private static final List<PostStartupListener> POST_STARTUP_LISTENERS = new ArrayList<PostStartupListener>();
    private static final List<StartupListener> STARTUP_LISTENERS = new ArrayList<StartupListener>();
    public static final String PROJECT_ADMIN_PRIVILEGES_KEY = "emfstore.accesscontrol.projectadmin";
    private static boolean testing;
    private static Properties properties;
    private static Map<PAPrivileges, Boolean> defaultPAPrivilegs;
    private static ESLocationProvider locationProvider;
    private static Boolean isChecksumComputationOnCommitActive;

    static {
        defaultPAPrivilegs = new LinkedHashMap<PAPrivileges, Boolean>(){
            {
                this.put(PAPrivileges.AssignRoleToOrgUnit, Boolean.TRUE);
                this.put(PAPrivileges.ChangeAssignmentsOfOrgUnits, Boolean.FALSE);
                this.put(PAPrivileges.ChangeUserPassword, Boolean.FALSE);
                this.put(PAPrivileges.CreateGroup, Boolean.FALSE);
                this.put(PAPrivileges.ShareProject, Boolean.FALSE);
                this.put(PAPrivileges.CreateUser, Boolean.FALSE);
                this.put(PAPrivileges.DeleteOrgUnit, Boolean.FALSE);
            }
        };
    }

    private ServerConfiguration() {
    }

    public static String getConfDirectory() {
        StringBuffer sb = new StringBuffer(ServerConfiguration.getServerHome());
        sb.append(".");
        sb.append(File.separatorChar);
        sb.append("conf");
        sb.append(File.separatorChar);
        return sb.toString();
    }

    public static boolean isProjectAdminPrivileg(PAPrivileges requestedPrivileg) {
        String[] definedPrivileges = ServerConfiguration.getSplittedProperty(PROJECT_ADMIN_PRIVILEGES_KEY);
        if (definedPrivileges == null) {
            return defaultPAPrivilegs.get((Object)requestedPrivileg);
        }
        String[] stringArray = definedPrivileges;
        int n = definedPrivileges.length;
        int n2 = 0;
        while (n2 < n) {
            String definedPrivileg = stringArray[n2];
            PAPrivileges privilege = PAPrivileges.valueOf(definedPrivileg);
            if (privilege.equals((Object)requestedPrivileg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getConfFile() {
        return String.valueOf(ServerConfiguration.getConfDirectory()) + ES_PROPERTIES;
    }

    public static String getServerHome() {
        String workspaceDirectory = ServerConfiguration.getLocationProvider().getWorkspaceDirectory();
        File workspace = new File(workspaceDirectory);
        if (!workspace.exists()) {
            workspace.mkdirs();
        }
        if (!workspaceDirectory.endsWith(File.separator)) {
            return String.valueOf(workspaceDirectory) + File.separatorChar;
        }
        return workspaceDirectory;
    }

    public static synchronized ESLocationProvider getLocationProvider() {
        if (locationProvider == null) {
            try {
                locationProvider = (ESLocationProvider)new ESExtensionPoint(LOCATION_PROVIDER_KEY, true).getClass("providerClass", ESLocationProvider.class);
            }
            catch (ESExtensionPointException eSExtensionPointException) {
                String message = Messages.ServerConfiguration_No_Location_Provider;
                ModelUtil.logWarning((String)message);
            }
            if (locationProvider == null) {
                locationProvider = new DefaultServerWorkspaceLocationProvider();
            }
        }
        return locationProvider;
    }

    public static String getStartArgument(String parameter) {
        String[] stringArray = Platform.getApplicationArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith(parameter) && arg.length() > parameter.length() && arg.charAt(parameter.length()) == '=') {
                return arg.substring(parameter.length() + 1, arg.length());
            }
            ++n2;
        }
        return null;
    }

    public static boolean isStartArgSet(String parameter) {
        String[] stringArray = Platform.getApplicationArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equals(parameter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getDefaultSPFVFilePath() {
        return String.valueOf(ServerConfiguration.getConfDirectory()) + "user.properties";
    }

    public static synchronized Properties getProperties() {
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }

    public static String[] getSplittedProperty(String property) {
        String result = ServerConfiguration.getProperties().getProperty(property);
        return result == null ? null : ServerConfiguration.splitProperty(result);
    }

    public static String[] getSplittedProperty(String property, String defaultValue) {
        String result = ServerConfiguration.getProperties().getProperty(property, defaultValue);
        return result == null ? null : ServerConfiguration.splitProperty(result);
    }

    private static String[] splitProperty(String property) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = property.split(MULTI_PROPERTY_SEPERATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            result.add(str.trim());
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public static void setProperties(Properties prop) {
        ServerConfiguration.setProperties(prop, true);
    }

    public static void setProperties(Properties prop, boolean keepExisting) {
        Properties beforeProperties = properties;
        properties = prop;
        if (keepExisting && beforeProperties != null) {
            properties.putAll((Map<?, ?>)beforeProperties);
        }
    }

    public static String getServerKeyStorePath() {
        return String.valueOf(ServerConfiguration.getServerHome()) + SERVER_KEYSTORE_FILE;
    }

    public static String getServerVersion() {
        Bundle emfStoreBundle = Platform.getBundle((String)SERVER_BUNDLE_KEY);
        String emfStoreVersionString = (String)emfStoreBundle.getHeaders().get("Bundle-Version");
        return emfStoreVersionString;
    }

    public static boolean isReleaseVersion() {
        return !ServerConfiguration.getServerVersion().endsWith("qualifier") && !ServerConfiguration.isInternalReleaseVersion();
    }

    public static boolean isInternalReleaseVersion() {
        return ServerConfiguration.getServerVersion().endsWith("internal");
    }

    public static void setTesting(boolean testing) {
        ServerConfiguration.testing = testing;
    }

    public static boolean isTesting() {
        return testing;
    }

    public static boolean isComputeChecksumOnCommitActive() {
        if (isChecksumComputationOnCommitActive == null) {
            try {
                isChecksumComputationOnCommitActive = new ESExtensionPoint(CHECKSUM_KEY, true).getBoolean("shouldComputeChecksumOnCommit");
            }
            catch (ESExtensionPointException eSExtensionPointException) {
                String message = Messages.ServerConfiguration_Default_Checksum_Behavior;
                ModelUtil.logWarning((String)message);
                isChecksumComputationOnCommitActive = true;
            }
        }
        return isChecksumComputationOnCommitActive;
    }

    public static List<StartupListener> getStartupListeners() {
        return STARTUP_LISTENERS;
    }

    public static void addStartupListener(StartupListener listener) {
        STARTUP_LISTENERS.add(listener);
    }

    public static List<PostStartupListener> getPostStartupListeners() {
        return POST_STARTUP_LISTENERS;
    }

    public static void addPostStartupListener(PostStartupListener listener) {
        POST_STARTUP_LISTENERS.add(listener);
    }
}

