/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent;

import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.Direction;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.ReadLineCapable;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationEmitter {
    private static final long NEWLINE_LENGTH = System.getProperty("line.separator").getBytes().length;
    private boolean withinOperationsElement;
    private final Direction direction;
    private long offset;

    public OperationEmitter(Direction direction) {
        this.direction = direction;
        this.offset = 0L;
    }

    public long getOffset() {
        return this.offset;
    }

    public Optional<AbstractOperation> tryEmit(ReadLineCapable reader) throws IOException {
        String line;
        ArrayList<String> readLines = new ArrayList<String>();
        this.withinOperationsElement = false;
        boolean isForwardDir = this.direction == Direction.Forward;
        while ((line = reader.readLine()) != null && !line.contains(this.getClosingTag(isForwardDir))) {
            if (line.contains(this.getOpeningTag(isForwardDir))) {
                this.withinOperationsElement = true;
            } else if (this.withinOperationsElement) {
                readLines.add(line);
            }
            this.offset += (long)line.getBytes().length;
            this.offset += NEWLINE_LENGTH;
        }
        if (line != null) {
            this.withinOperationsElement = false;
            this.offset += (long)line.getBytes().length;
        }
        if (!this.withinOperationsElement && !readLines.isEmpty()) {
            if (this.direction == Direction.Backward) {
                Collections.reverse(readLines);
            }
            return Optional.of((Object)this.deserialize(StringUtils.join(readLines, (String)"")));
        }
        return Optional.absent();
    }

    private String getClosingTag(boolean isForward) {
        return isForward ? "</operations>" : "<operations>";
    }

    private String getOpeningTag(boolean isForward) {
        return isForward ? "<operations>" : "</operations>";
    }

    private AbstractOperation deserialize(String string) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)"virtualResource.xmi"));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(string.getBytes());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        resource.load((InputStream)inputStream, ModelUtil.getResourceLoadOptions());
        AbstractOperation operation = (AbstractOperation)resource.getContents().get(0);
        if (operation instanceof CreateDeleteOperation) {
            ((CreateDeleteOperation)operation).getSubOperations();
        }
        return operation;
    }
}

