/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.test;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.emfstore.fuzzy.Annotations;
import org.eclipse.emf.emfstore.fuzzy.FuzzyRunner;
import org.eclipse.emf.emfstore.fuzzy.emf.EMFDataProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.MutateUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.common.model.ModelPackage;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutator;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutatorConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FuzzyRunner.class)
@Annotations.DataProvider(value=EMFDataProvider.class)
public class MutatorTest {
    @Annotations.Data
    private EObject obj;
    @Annotations.Util
    private MutateUtil util;

    @Test
    public void compareTwoGeneratedProjects() {
        EObject modelElement;
        ModelElementId modelElementId;
        Project project1 = ModelFactory.eINSTANCE.createProject();
        Project project2 = ModelFactory.eINSTANCE.createProject();
        ModelMutator.generateModel((ModelMutatorConfiguration)this.getConfig(project1));
        ModelMutator.generateModel((ModelMutatorConfiguration)this.getConfig(project2));
        ModelMutator.changeModel((ModelMutatorConfiguration)this.getConfig(project1));
        ModelMutator.changeModel((ModelMutatorConfiguration)this.getConfig(project2));
        Iterator project1Iterator = project1.getAllModelElements().iterator();
        Iterator project2Iterator = project2.getAllModelElements().iterator();
        while (project1Iterator.hasNext()) {
            EObject modelElement2 = (EObject)project1Iterator.next();
            ModelElementId modelElementId2 = project1.getModelElementId(modelElement2);
            if (project2.contains(modelElementId2)) continue;
            this.failed(project1, project2);
        }
        TreeIterator allContentsProject1 = project1.eAllContents();
        TreeIterator allContentsProject2 = project2.eAllContents();
        while (allContentsProject1.hasNext()) {
            EObject modelElement2;
            ModelElementId modelElementId2;
            if (!allContentsProject2.hasNext()) {
                this.failed(project1, project2);
            }
            if ((modelElementId = project1.getModelElementId(modelElement = (EObject)allContentsProject1.next())).equals(modelElementId2 = project2.getModelElementId(modelElement2 = (EObject)allContentsProject2.next()))) continue;
            this.failed(project1, project2);
        }
        project1Iterator = project1.getAllModelElements().iterator();
        project2Iterator = project2.getAllModelElements().iterator();
        while (project1Iterator.hasNext()) {
            ModelElementId modelElementId2;
            modelElement = (EObject)project1Iterator.next();
            modelElementId = project1.getModelElementId(modelElement);
            if (modelElementId.equals(modelElementId2 = project2.getModelElementId((EObject)project2Iterator.next()))) continue;
            this.failed(project1, project2);
        }
    }

    private void failed(Project project1, Project project2) {
        this.util.saveEObject((EObject)project1, "original_project", true);
        this.util.saveEObject((EObject)project2, "own_project", true);
        Assert.assertTrue((boolean)false);
    }

    private ModelMutatorConfiguration getConfig(Project root) {
        ModelMutatorConfiguration mmc = new ModelMutatorConfiguration(this.util.getEPackages(), (EObject)root, Long.valueOf(this.util.getSeed()));
        HashSet<EReference> eStructuralFeaturesToIgnore = new HashSet<EReference>();
        eStructuralFeaturesToIgnore.add(ModelPackage.Literals.PROJECT__CUT_ELEMENTS);
        mmc.seteStructuralFeaturesToIgnore(eStructuralFeaturesToIgnore);
        mmc.setMinObjectsCount(this.util.getMinObjectsCount());
        return mmc;
    }
}

