/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.AbstractPlotRenderer;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.IPlotCommit;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.PlotLane;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class SWTPlotRenderer
extends AbstractPlotRenderer {
    private static final int MAX_LABEL_LENGTH = 15;
    private final Color sysColorBlack;
    private final Color sysColorGray;
    private final Color sysColorWhite;
    private final Color commitDotFill;
    private final Color commitDotOutline;
    private final Map<String, Point> labelCoordinates = new LinkedHashMap<String, Point>();
    private int textHeight;
    private boolean enableAntialias = true;
    private GC g;
    private int cellX;
    private int cellY;
    private Color cellFG;
    private Color cellBG;

    public SWTPlotRenderer(Display d) {
        this.sysColorBlack = d.getSystemColor(2);
        this.sysColorGray = d.getSystemColor(15);
        this.sysColorWhite = d.getSystemColor(1);
        this.commitDotFill = new Color((Device)d, new RGB(220, 220, 220));
        this.commitDotOutline = new Color((Device)d, new RGB(110, 110, 110));
    }

    void dispose() {
        this.commitDotFill.dispose();
        this.commitDotOutline.dispose();
    }

    public void paint(Event event, IPlotCommit representer) {
        this.g = event.gc;
        if (this.enableAntialias) {
            try {
                this.g.setAntialias(1);
            }
            catch (SWTException sWTException) {
                this.enableAntialias = false;
            }
        }
        this.cellX = event.x;
        this.cellY = event.y;
        this.cellFG = this.g.getForeground();
        this.cellBG = this.g.getBackground();
        if (this.textHeight == 0) {
            this.textHeight = this.g.stringExtent((String)"/").y;
        }
        this.paintCommit(representer, event.height);
    }

    protected void drawLine(Color color, int x1, int y1, int x2, int y2, int width) {
        this.g.setForeground(color);
        this.g.setLineWidth(width);
        this.g.drawLine(this.cellX + x1, this.cellY + y1, this.cellX + x2, this.cellY + y2);
    }

    protected void drawDot(Color outline, Color fill, int x, int y, int w, int h) {
        int dotX = this.cellX + x + 2;
        int dotY = this.cellY + y + 1;
        int dotW = w - 2;
        int dotH = h - 2;
        this.g.setBackground(fill);
        this.g.fillOval(dotX, dotY, dotW, dotH);
        this.g.setForeground(outline);
        this.g.setLineWidth(2);
        this.g.drawOval(dotX, dotY, dotW, dotH);
    }

    protected void drawCommitDot(int x, int y, int w, int h) {
        this.drawDot(this.commitDotOutline, this.commitDotFill, x, y, w, h);
    }

    protected void drawBoundaryDot(int x, int y, int w, int h) {
        this.drawDot(this.sysColorGray, this.sysColorWhite, x, y, w, h);
    }

    protected void drawText(String msg, int x, int y) {
        Point textsz = this.g.textExtent(msg);
        int texty = (y * 2 - textsz.y) / 2;
        this.g.setForeground(this.cellFG);
        this.g.setBackground(this.cellBG);
        this.g.drawString(msg, this.cellX + x, this.cellY + texty, true);
    }

    protected int drawLabel(int x, int y, IPlotCommit commit) {
        String txt = commit.getBranch();
        int maxLength = 15;
        if (txt.length() > maxLength) {
            txt = String.valueOf(txt.substring(0, maxLength)) + "\u2026";
        }
        Point textsz = this.g.stringExtent(txt);
        int arc = textsz.y / 2;
        int texty = (y * 2 - textsz.y) / 2;
        this.g.setLineWidth(1);
        this.g.setBackground(this.sysColorWhite);
        this.g.setForeground(this.getLabelBorderColor(commit));
        this.g.setBackground(this.getLabelColor(commit));
        this.g.fillRoundRectangle(this.cellX + x + 1, this.cellY + texty, textsz.x + 6, textsz.y - 1, arc, arc);
        this.g.drawRoundRectangle(this.cellX + x, this.cellY + texty, textsz.x + 7, textsz.y - 1, arc, arc);
        this.g.setForeground(this.sysColorBlack);
        this.g.drawString(txt, this.cellX + x + 4, this.cellY + texty, true);
        this.labelCoordinates.put(String.valueOf(commit.getId()), new Point(x, x + textsz.x));
        return 10 + textsz.x;
    }

    private Color getLabelBorderColor(IPlotCommit commit) {
        return commit.getColor();
    }

    private Color getLabelColor(IPlotCommit commit) {
        return commit.getLightColor();
    }

    protected Color laneColor(PlotLane myLane, boolean fullSaturation) {
        Color color = myLane == null ? (fullSaturation ? this.sysColorBlack : this.sysColorGray) : (fullSaturation ? myLane.getSaturatedColor() : myLane.getLightColor());
        if (color == null) {
            assert (false);
            color = this.sysColorGray;
        }
        return color;
    }

    public int getTextHeight() {
        return this.textHeight;
    }
}

