/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.util.EMFStorePreferenceHelper;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportItemWrapper;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport.ImportSource;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CSVImportSource
extends ImportSource {
    private static final String CSV_IMPORT_SOURCE_PATH = "org.eclipse.emf.emfstore.client.ui.CSVImportSourcePath";
    private final Map<String, ImportItemWrapper> groupMap = new LinkedHashMap<String, ImportItemWrapper>();
    private ArrayList<ImportItemWrapper> groups;
    private ArrayList<ImportItemWrapper> users;
    private String absFileName;

    public Object[] getChildren(Object ob) {
        ImportItemWrapper importWrapper = (ImportItemWrapper)ob;
        if (importWrapper != null && importWrapper.getChildOrgUnits() != null) {
            return importWrapper.getChildOrgUnits().toArray();
        }
        return null;
    }

    public Object[] getElements(Object ob) {
        return this.groups.toArray();
    }

    public String getLabel() {
        return "import from CSV file";
    }

    /*
     * Loose catch block
     */
    public boolean init(Shell shell) {
        this.groups = new ArrayList();
        this.users = new ArrayList();
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setText("Choose import file");
        String initialPath = EMFStorePreferenceHelper.getPreference(CSV_IMPORT_SOURCE_PATH, System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        String fn = dialog.open();
        if (fn == null) {
            return false;
        }
        String fileName = dialog.getFileName();
        String filterPath = dialog.getFilterPath();
        if (fileName == null) {
            return false;
        }
        this.absFileName = String.valueOf(filterPath) + File.separatorChar + fileName;
        File file = new File(this.absFileName);
        EMFStorePreferenceHelper.setPreference(CSV_IMPORT_SOURCE_PATH, filterPath);
        BufferedReader bufferedReader = null;
        InputStreamReader isr = null;
        try {
            try {
                isr = new InputStreamReader(new FileInputStream(file));
                bufferedReader = new BufferedReader(isr);
                String line = bufferedReader.readLine();
                while ((line = bufferedReader.readLine()) != null) {
                    ArrayList<ImportItemWrapper> childOrgUnits;
                    String[] title = line.split(",");
                    String userName = title[0];
                    String groupName = title[1];
                    ImportItemWrapper importWrapper = null;
                    if (this.groupMap.get(groupName) == null) {
                        ACGroup group = AccesscontrolFactory.eINSTANCE.createACGroup();
                        importWrapper = new ImportItemWrapper(null, (ACOrgUnit)group);
                        group.setName(groupName);
                        this.groups.add(importWrapper);
                        this.groupMap.put(groupName, importWrapper);
                        childOrgUnits = new ArrayList();
                    } else {
                        importWrapper = this.groupMap.get(groupName);
                        childOrgUnits = importWrapper.getChildOrgUnits();
                    }
                    ACUser user = AccesscontrolFactory.eINSTANCE.createACUser();
                    user.setName(userName);
                    ImportItemWrapper userImportWrapper = new ImportItemWrapper(null, (ACOrgUnit)user, importWrapper);
                    this.users.add(userImportWrapper);
                    childOrgUnits.add(userImportWrapper);
                    importWrapper.setChildOrgUnits(childOrgUnits);
                }
            }
            catch (FileNotFoundException e) {
                WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
                EMFStoreMessageDialog.showExceptionDialog("File not found", (Exception)e);
                try {
                    bufferedReader.close();
                    isr.close();
                }
                catch (IOException e2) {
                    WorkspaceUtil.logWarning((String)e2.getMessage(), (Exception)e2);
                    EMFStoreMessageDialog.showExceptionDialog("An I/O-exception occured", (Exception)e2);
                    return false;
                }
                return false;
            }
            catch (IOException e) {
                WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
                EMFStoreMessageDialog.showExceptionDialog("An I/O-exception occured", (Exception)e);
                try {
                    bufferedReader.close();
                    isr.close();
                }
                catch (IOException e3) {
                    WorkspaceUtil.logWarning((String)e3.getMessage(), (Exception)e3);
                    EMFStoreMessageDialog.showExceptionDialog("An I/O-exception occured", (Exception)e3);
                    return false;
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
                EMFStoreMessageDialog.showExceptionDialog("ArrayIndexOutOfBoundsException", (Exception)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    bufferedReader.close();
                    isr.close();
                }
                catch (IOException e4) {
                    WorkspaceUtil.logWarning((String)e4.getMessage(), (Exception)e4);
                    EMFStoreMessageDialog.showExceptionDialog("An I/O-exception occured", (Exception)e4);
                    return false;
                }
                return false;
            }
        }
        finally {
            try {
                bufferedReader.close();
                isr.close();
            }
            catch (IOException e) {
                WorkspaceUtil.logWarning((String)e.getMessage(), (Exception)e);
                EMFStoreMessageDialog.showExceptionDialog("An I/O-exception occured", (Exception)e);
                return false;
            }
        }
        return true;
    }

    public String getMessage() {
        return "Importing from file: " + this.absFileName;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }
}

