/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.ExtensionRegistry;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucketCandidate;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ReservationSet;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ReservationSetModifier;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ContainmentType;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.FeatureOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservationToConflictBucketCandidateMap {
    private static ReservationSetModifier reservationSetModifier = ReservationToConflictBucketCandidateMap.initCustomReservationSetModifier();
    private final ReservationSet reservationToConflictMap = new ReservationSet();
    private final Set<ConflictBucketCandidate> conflictBucketCandidates = new LinkedHashSet<ConflictBucketCandidate>();
    private final Map<String, Integer> idToKeyHashCode = new LinkedHashMap<String, Integer>();

    private static ReservationSetModifier initCustomReservationSetModifier() {
        return (ReservationSetModifier)ExtensionRegistry.INSTANCE.get("org.eclipse.emf.emfstore.server.conflictDetection.reservationSetModifiier", ReservationSetModifier.class, (Object)new ReservationSetModifier(){

            public ReservationSet addCustomReservation(AbstractOperation operation, ReservationSet reservationSet, ModelElementIdToEObjectMapping mapping) {
                return reservationSet;
            }
        }, true);
    }

    private void joinReservationSet(ReservationSet reservationSet, ConflictBucketCandidate currentConflictBucketCandidate) {
        Set<String> modelElements = reservationSet.getAllModelElements();
        for (String modelElement : modelElements) {
            if (reservationSet.hasFullReservation(modelElement) || this.reservationToConflictMap.hasFullReservation(modelElement)) {
                ConflictBucketCandidate mergedConflictBucketCandidates = this.mergeConflictBucketCandidates(this.reservationToConflictMap.getConflictBucketCandidates(modelElement), currentConflictBucketCandidate);
                this.reservationToConflictMap.addFullReservation(modelElement, mergedConflictBucketCandidates);
                continue;
            }
            if (reservationSet.hasExistenceReservation(modelElement)) {
                this.reservationToConflictMap.addExistenceReservation(modelElement, currentConflictBucketCandidate);
            }
            Set<String> featureNames = reservationSet.getFeatureNames(modelElement);
            for (String featureName : featureNames) {
                if (featureName.equals("+existence")) continue;
                if (!reservationSet.hasOppositeReservations(modelElement, featureName)) {
                    this.handleFeatureVsFeatureReservation(currentConflictBucketCandidate, modelElement, featureName);
                    continue;
                }
                this.handleOppositeVsOppositeReservation(reservationSet, currentConflictBucketCandidate, modelElement, featureName);
            }
        }
    }

    private void handleFeatureVsFeatureReservation(ConflictBucketCandidate currentConflictBucketCandidate, String modelElement, String featureName) {
        if (this.reservationToConflictMap.hasFeatureReservation(modelElement, featureName)) {
            Set<ConflictBucketCandidate> existingBuckets = this.reservationToConflictMap.getConflictBucketCandidates(modelElement, featureName);
            ConflictBucketCandidate mergedConflictBucketCandidates = this.mergeConflictBucketCandidates(existingBuckets, currentConflictBucketCandidate);
            this.reservationToConflictMap.addFeatureReservation(modelElement, featureName, mergedConflictBucketCandidates);
        } else {
            if (this.reservationToConflictMap.hasOppositeReservations(modelElement, featureName)) {
                throw new IllegalStateException("Reservation for same feature with and without opposites is illegal!");
            }
            this.reservationToConflictMap.addFeatureReservation(modelElement, featureName, currentConflictBucketCandidate);
        }
    }

    private void handleOppositeVsOppositeReservation(ReservationSet reservationSet, ConflictBucketCandidate currentConflictBucketCandidate, String modelElement, String featureName) {
        if (this.reservationToConflictMap.hasOppositeReservations(modelElement, featureName)) {
            Set<String> opposites = reservationSet.getOpposites(modelElement, featureName);
            for (String oppositeModelElement : opposites) {
                if (!this.reservationToConflictMap.hasOppositeReservation(modelElement, featureName, oppositeModelElement)) continue;
                ConflictBucketCandidate mergedConflictBucketCandidates = this.mergeConflictBucketCandidates(this.reservationToConflictMap.getConflictBucketCandidates(modelElement, featureName, oppositeModelElement), currentConflictBucketCandidate);
                this.reservationToConflictMap.addMultiReferenceWithOppositeReservation(modelElement, featureName, oppositeModelElement, mergedConflictBucketCandidates);
            }
        } else {
            if (this.reservationToConflictMap.hasFeatureReservation(modelElement, featureName)) {
                throw new IllegalStateException("Reservation for same feature with and without opposites is illegal!");
            }
            Set<String> opposites = reservationSet.getOpposites(modelElement, featureName);
            for (String oppositeModelElement : opposites) {
                this.reservationToConflictMap.addMultiReferenceWithOppositeReservation(modelElement, featureName, oppositeModelElement, currentConflictBucketCandidate);
            }
        }
    }

    private ConflictBucketCandidate mergeConflictBucketCandidates(Set<ConflictBucketCandidate> existingBuckets, ConflictBucketCandidate currentBucket) {
        ConflictBucketCandidate rootBucket = currentBucket.getRootConflictBucketCandidate();
        for (ConflictBucketCandidate otherBucket : existingBuckets) {
            otherBucket.getRootConflictBucketCandidate().setParentConflictBucketCandidate(rootBucket);
        }
        return rootBucket;
    }

    public void scanOperationReservations(AbstractOperation operation, int priority, ModelElementIdToEObjectMapping idToEObjectMapping, boolean isMyOperation) {
        ReservationSet reservationSet = this.extractReservationFromOperation(operation, new ReservationSet(), idToEObjectMapping);
        reservationSet = this.addCustomReservations(operation, reservationSet, idToEObjectMapping);
        ConflictBucketCandidate conflictBucketCandidate = new ConflictBucketCandidate();
        this.conflictBucketCandidates.add(conflictBucketCandidate);
        conflictBucketCandidate.addOperation(operation, isMyOperation, priority);
        this.joinReservationSet(reservationSet, conflictBucketCandidate);
    }

    private ReservationSet addCustomReservations(AbstractOperation operation, ReservationSet reservationSet, ModelElementIdToEObjectMapping idToEObjectMapping) {
        return reservationSetModifier.addCustomReservation(operation, reservationSet, idToEObjectMapping);
    }

    private ReservationSet extractReservationFromOperation(AbstractOperation operation, ReservationSet reservationSet, ModelElementIdToEObjectMapping idToEObjectMapping) {
        if (operation instanceof CompositeOperation) {
            CompositeOperation compositeOperation = (CompositeOperation)operation;
            for (AbstractOperation subOperation : compositeOperation.getSubOperations()) {
                this.extractReservationFromOperation(subOperation, reservationSet, idToEObjectMapping);
            }
            return reservationSet;
        }
        if (operation instanceof CreateDeleteOperation) {
            CreateDeleteOperation createDeleteOperation = (CreateDeleteOperation)operation;
            if (createDeleteOperation.isDelete()) {
                for (ModelElementId modelElementId : createDeleteOperation.getEObjectToIdMap().values()) {
                    reservationSet.addFullReservation(modelElementId.getId());
                }
            } else {
                for (EObject eObject : createDeleteOperation.getEObjectToIdMap().keySet()) {
                    if (!this.isMapEntry(eObject)) continue;
                    this.handleMapEntry((Map.Entry)eObject, createDeleteOperation, idToEObjectMapping);
                }
            }
            for (AbstractOperation subOperation : createDeleteOperation.getSubOperations()) {
                this.extractReservationFromOperation(subOperation, reservationSet, idToEObjectMapping);
            }
            return reservationSet;
        }
        if (operation instanceof FeatureOperation) {
            this.handleFeatureOperation(operation, reservationSet, idToEObjectMapping);
            return reservationSet;
        }
        throw new IllegalStateException("Unkown operation type: " + operation.getClass().getCanonicalName());
    }

    private boolean isMapEntry(EObject eObject) {
        return eObject instanceof Map.Entry;
    }

    private void handleMapEntry(Map.Entry<?, ?> mapEntry, CreateDeleteOperation createDeleteOperation, ModelElementIdToEObjectMapping idToEObjectMapping) {
        String mapEntryId = ((ModelElementId)createDeleteOperation.getEObjectToIdMap().get(mapEntry)).getId();
        if (mapEntry.getKey() != null) {
            this.idToKeyHashCode.put(mapEntryId, new Integer(mapEntry.getKey().hashCode()));
            return;
        }
        ReferenceOperation keyReferenceOperation = this.getKeyReferenceOperation(createDeleteOperation);
        if (keyReferenceOperation != null) {
            Set otherInvolvedModelElements = keyReferenceOperation.getOtherInvolvedModelElements();
            Iterator iterator = otherInvolvedModelElements.iterator();
            if (iterator.hasNext()) {
                ModelElementId otherId = (ModelElementId)iterator.next();
                EObject key = idToEObjectMapping.get((Object)otherId);
                if (key != null) {
                    this.idToKeyHashCode.put(mapEntryId, new Integer(key.hashCode()));
                } else {
                    ModelUtil.logWarning((String)"Key is null. Can not be used for conflict detection.");
                }
            }
        } else {
            ModelUtil.logWarning((String)MessageFormat.format("Single reference sub operation of create operation {0} is missing", createDeleteOperation.getOperationId()));
        }
    }

    private ReferenceOperation getKeyReferenceOperation(CreateDeleteOperation createDeleteOperation) {
        for (AbstractOperation op : createDeleteOperation.getSubOperations()) {
            SingleReferenceOperation singleReferenceOperation;
            if (!SingleReferenceOperation.class.isInstance(op) || !(singleReferenceOperation = (SingleReferenceOperation)SingleReferenceOperation.class.cast(op)).getFeatureName().equals("key")) continue;
            return singleReferenceOperation;
        }
        return null;
    }

    private void handleFeatureOperation(AbstractOperation operation, ReservationSet reservationSet, ModelElementIdToEObjectMapping idToEObjectMapping) {
        FeatureOperation featureOperation = (FeatureOperation)operation;
        String modelElementId = featureOperation.getModelElementId().getId();
        String featureName = featureOperation.getFeatureName();
        if (featureOperation instanceof ReferenceOperation) {
            ReferenceOperation referenceOperation = (ReferenceOperation)featureOperation;
            for (ModelElementId otherModelElement : referenceOperation.getOtherInvolvedModelElements()) {
                if (referenceOperation.getContainmentType().equals((Object)ContainmentType.CONTAINMENT) && !referenceOperation.isBidirectional()) {
                    reservationSet.addContainerReservation(otherModelElement.getId());
                    continue;
                }
                reservationSet.addExistenceReservation(otherModelElement.getId());
            }
        }
        if (OperationUtil.isMultiRef((AbstractOperation)featureOperation) || OperationUtil.isMultiRefSet((AbstractOperation)featureOperation) || OperationUtil.isMultiMoveRef((AbstractOperation)featureOperation)) {
            for (ModelElementId otherModelElement : featureOperation.getOtherInvolvedModelElements()) {
                reservationSet.addMultiReferenceWithOppositeReservation(modelElementId, featureName, otherModelElement.getId());
                Integer hashCode = null;
                if (this.isCreatedMapEntry(otherModelElement)) {
                    hashCode = this.getKeyHashCode(otherModelElement);
                } else if (this.isMapEntry(idToEObjectMapping.get((Object)otherModelElement))) {
                    hashCode = this.getKeyHashCode(idToEObjectMapping, otherModelElement);
                }
                if (hashCode == null) continue;
                reservationSet.addMapKeyReservation(modelElementId, featureName, hashCode.toString());
            }
        } else {
            reservationSet.addFeatureReservation(modelElementId, featureName);
        }
    }

    private Integer getKeyHashCode(ModelElementIdToEObjectMapping idToEObjectMapping, ModelElementId keyId) {
        Map.Entry mapEntry = (Map.Entry)idToEObjectMapping.get((Object)keyId);
        if (mapEntry.getKey() != null) {
            return new Integer(mapEntry.getKey().hashCode());
        }
        return null;
    }

    private Integer getKeyHashCode(ModelElementId keyId) {
        return this.idToKeyHashCode.get(keyId);
    }

    private boolean isCreatedMapEntry(ModelElementId modelElementId) {
        return this.idToKeyHashCode.containsKey(modelElementId.getId());
    }

    public Set<ConflictBucketCandidate> getConflictBucketCandidates() {
        LinkedHashMap<ConflictBucketCandidate, LinkedHashSet<ConflictBucketCandidate>> rootToBucketMergeSetMap = new LinkedHashMap<ConflictBucketCandidate, LinkedHashSet<ConflictBucketCandidate>>();
        for (ConflictBucketCandidate candidate : this.conflictBucketCandidates) {
            ConflictBucketCandidate root = candidate.getRootConflictBucketCandidate();
            LinkedHashSet<ConflictBucketCandidate> bucketMergeSet = (LinkedHashSet<ConflictBucketCandidate>)rootToBucketMergeSetMap.get(root);
            if (bucketMergeSet == null) {
                bucketMergeSet = new LinkedHashSet<ConflictBucketCandidate>();
                rootToBucketMergeSetMap.put(root, bucketMergeSet);
            }
            bucketMergeSet.add(candidate);
        }
        for (ConflictBucketCandidate root : rootToBucketMergeSetMap.keySet()) {
            for (ConflictBucketCandidate sibling : (Set)rootToBucketMergeSetMap.get(root)) {
                root.addConflictBucketCandidate(sibling);
            }
        }
        return rootToBucketMergeSetMap.keySet();
    }
}

