/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin;

import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.GroupTabContent;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.ProjectTabContent;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.TabContent;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.UserTabContent;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OrgUnitManagementGUI {
    private TabContent activeTabContent;
    private ProjectTabContent projectsTabContents;
    private GroupTabContent groupsTabContents;
    private UserTabContent usersTabContents;
    private TabFolder tabFolder;

    public OrgUnitManagementGUI(Composite parent, AdminBroker adminBroker) {
        this.createSash(parent, adminBroker);
    }

    private void createSash(Composite parent, AdminBroker adminBroker) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTabFolder(sash);
        PropertiesForm frm = this.createPropertiesForm(sash, adminBroker);
        this.initTabFolder(adminBroker, frm);
        sash.setWeights(this.sashWeights());
    }

    private void createTabFolder(SashForm sash) {
        this.tabFolder = new TabFolder((Composite)sash, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                switch (OrgUnitManagementGUI.this.tabFolder.getSelectionIndex()) {
                    case 0: {
                        OrgUnitManagementGUI.this.activeTabContent = OrgUnitManagementGUI.this.projectsTabContents;
                        break;
                    }
                    case 1: {
                        OrgUnitManagementGUI.this.activeTabContent = OrgUnitManagementGUI.this.groupsTabContents;
                        break;
                    }
                    case 2: {
                        OrgUnitManagementGUI.this.activeTabContent = OrgUnitManagementGUI.this.usersTabContents;
                        break;
                    }
                }
            }
        });
    }

    private PropertiesForm createPropertiesForm(SashForm sash, AdminBroker adminBroker) {
        FormToolkit toolkit = new FormToolkit(sash.getDisplay());
        PropertiesForm frm = new PropertiesForm((Composite)sash, 0, adminBroker, this);
        frm.setText("Properties");
        frm.setFont(JFaceResources.getHeaderFont());
        toolkit.decorateFormHeading((Form)frm);
        return frm;
    }

    private void initTabFolder(AdminBroker adminBroker, PropertiesForm frm) {
        TabItem projectsTab = new TabItem(this.tabFolder, 0);
        this.projectsTabContents = new ProjectTabContent("Projects", adminBroker, frm);
        projectsTab.setControl((Control)this.projectsTabContents.createContents(this.tabFolder));
        projectsTab.setText("Projects");
        TabItem groupsTab = new TabItem(this.tabFolder, 0);
        this.groupsTabContents = new GroupTabContent("Groups", adminBroker, frm);
        groupsTab.setControl((Control)this.groupsTabContents.createContents(this.tabFolder));
        groupsTab.setText("Groups");
        TabItem usersTab = new TabItem(this.tabFolder, 0);
        this.usersTabContents = new UserTabContent("Users", adminBroker, frm);
        usersTab.setControl((Control)this.usersTabContents.createContents(this.tabFolder));
        usersTab.setText("Users");
        this.tabFolder.setSelection(projectsTab);
        this.projectsTabContents.viewStarted();
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrgUnitManagementGUI.this.projectsTabContents.getTableViewer().refresh();
                OrgUnitManagementGUI.this.groupsTabContents.getTableViewer().refresh();
                OrgUnitManagementGUI.this.usersTabContents.getTableViewer().refresh();
            }
        });
    }

    private int[] sashWeights() {
        return new int[]{25, 75};
    }

    public TabContent getActiveTabContent() {
        return this.activeTabContent;
    }
}

