/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.CommandObserver;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.NotificationRecorder;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationRecorder;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationRecorderConfig;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationRecorderListener;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.observers.OperationObserver;
import org.eclipse.emf.emfstore.internal.common.ESDisposable;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.semantic.SemanticCompositeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationManager
implements OperationRecorderListener,
ESDisposable,
CommandObserver,
IdEObjectCollectionChangeObserver {
    private final OperationRecorder operationRecorder;
    private final List<OperationObserver> operationListeners;
    private final ProjectSpace projectSpace;

    public OperationManager(ProjectSpaceBase projectSpace) {
        this.operationRecorder = new OperationRecorder(projectSpace);
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this.operationRecorder);
        this.operationRecorder.addOperationRecorderListener(this);
        this.operationListeners = new ArrayList<OperationObserver>();
        this.configureOperationRecorder();
        this.projectSpace = this.operationRecorder.getProjectSpace();
    }

    private void configureOperationRecorder() {
        this.operationRecorder.getConfig().setCutOffIncomingCrossReferences(new ESExtensionPoint("org.eclipse.emf.emfstore.client.recordingOptions").getBoolean("cutOffIncomingCrossReferences", true));
        this.operationRecorder.getConfig().setForceCommands(new ESExtensionPoint("org.eclipse.emf.emfstore.client.recordingOptions").getBoolean("forceCommands", false));
        this.operationRecorder.getConfig().setDenyAddCutElementsToModelElements(new ESExtensionPoint("org.eclipse.emf.emfstore.client.recordingOptions").getBoolean("denyAddCutElementsToModelElements", false));
    }

    public void undoLastOperation() {
        this.projectSpace.undoLastOperations(1);
    }

    public void addOperationObserver(OperationObserver operationObserver) {
        this.operationListeners.add(operationObserver);
    }

    public void removeOperationListener(OperationObserver operationObserver) {
        this.operationListeners.remove(operationObserver);
    }

    public void notifyOperationUndone(AbstractOperation operation) {
        for (OperationObserver operationListener : this.operationListeners) {
            operationListener.operationUndone(operation);
        }
    }

    void notifyOperationExecuted(AbstractOperation operation) {
        for (OperationObserver operationListener : this.operationListeners) {
            operationListener.operationExecuted(operation);
        }
    }

    public void abortCompositeOperation() {
        this.undoLastOperation();
        this.operationRecorder.abortCompositeOperation();
    }

    public void endCompositeOperation() {
        this.notifyOperationExecuted((AbstractOperation)this.operationRecorder.getCompositeOperation());
        this.operationRecorder.endCompositeOperation();
    }

    public void endCompositeOperation(SemanticCompositeOperation semanticCompositeOperation) {
        List<AbstractOperation> operations = this.projectSpace.getOperations();
        operations.remove(operations.size() - 1);
        operations.add((AbstractOperation)semanticCompositeOperation);
        this.endCompositeOperation();
    }

    public CompositeOperationHandle beginCompositeOperation() {
        return this.operationRecorder.beginCompositeOperation();
    }

    @Override
    public void operationsRecorded(List<? extends AbstractOperation> operations) {
        this.projectSpace.addOperations(operations);
    }

    public List<AbstractOperation> clearOperations() {
        return this.operationRecorder.clearOperations();
    }

    public void dispose() {
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this.operationRecorder);
        this.operationRecorder.removeOperationRecorderListener(this);
    }

    public NotificationRecorder getNotificationRecorder() {
        return this.operationRecorder.getNotificationRecorder();
    }

    @Override
    public void commandStarted(Command command) {
        this.operationRecorder.commandStarted(command);
    }

    @Override
    public void commandCompleted(Command command) {
        this.operationRecorder.commandCompleted(command);
    }

    @Override
    public void commandFailed(Command command, Exception exception) {
        this.operationRecorder.commandFailed(command, exception);
    }

    public void notify(Notification notification, IdEObjectCollection collection, EObject modelElement) {
        this.operationRecorder.notify(notification, collection, modelElement);
    }

    public void modelElementAdded(IdEObjectCollection collection, EObject modelElement) {
        this.operationRecorder.modelElementAdded(collection, modelElement);
    }

    public void modelElementRemoved(IdEObjectCollection collection, EObject modelElement) {
        this.operationRecorder.modelElementRemoved(collection, modelElement);
    }

    public void collectionDeleted(IdEObjectCollection collection) {
        this.operationRecorder.collectionDeleted(collection);
    }

    public void startChangeRecording() {
        this.operationRecorder.startChangeRecording();
    }

    public void stopChangeRecording() {
        this.operationRecorder.stopChangeRecording();
    }

    public OperationRecorderConfig getRecorderConfig() {
        return this.operationRecorder.getConfig();
    }
}

