/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.extensionpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.common.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ESExtensionPoint {
    private List<ESExtensionElement> elements;
    private final String id;
    private boolean exceptionInsteadOfNull;
    private Comparator<ESExtensionElement> comparator;

    public ESExtensionPoint(String id) {
        this(id, false);
    }

    public ESExtensionPoint(String id, boolean throwException) {
        this.id = id;
        this.exceptionInsteadOfNull = throwException;
        this.comparator = this.getDefaultComparator();
        this.reload();
    }

    public void reload() {
        this.elements = new ArrayList<ESExtensionElement>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(this.id);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.elements.add(new ESExtensionElement(element, this.exceptionInsteadOfNull));
            ++n2;
        }
        Collections.sort(this.elements, this.comparator);
    }

    protected Comparator<ESExtensionElement> getDefaultComparator() {
        return new Comparator<ESExtensionElement>(){

            @Override
            public int compare(ESExtensionElement o1, ESExtensionElement o2) {
                return 0;
            }
        };
    }

    public <T> T getClass(String classAttributeName, Class<T> returnType) {
        ESExtensionElement first = this.getElementWithHighestPriority();
        if (first != null) {
            return first.getClass(classAttributeName, returnType);
        }
        return (T)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public Boolean getBoolean(String name, boolean defaultValue) {
        ESExtensionElement element = this.getElementWithHighestPriority();
        if (element != null) {
            return element.getBoolean(name, defaultValue);
        }
        ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
        return defaultValue;
    }

    public Integer getInteger(String name) {
        ESExtensionElement element = this.getElementWithHighestPriority();
        if (element != null) {
            return element.getInteger(name);
        }
        return (Integer)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
    }

    public String getAttribute(String name) {
        ESExtensionElement element = this.getElementWithHighestPriority();
        if (element != null) {
            return element.getAttribute(name);
        }
        return (String)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
    }

    public ESExtensionElement getElementWithHighestPriority() {
        return this.getFirst();
    }

    public void setComparator(Comparator<ESExtensionElement> comparator) {
        this.comparator = comparator;
    }

    public ESExtensionElement getFirst() {
        if (this.elements.size() > 0) {
            return this.elements.get(0);
        }
        return (ESExtensionElement)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
    }

    public List<ESExtensionElement> getExtensionElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public ESExtensionPoint setThrowException(boolean b) {
        this.exceptionInsteadOfNull = b;
        return this;
    }

    protected static Object handleErrorOrNull(boolean useException, Exception expOrNull) {
        if (useException) {
            if (expOrNull == null) {
                throw new ESExtensionPointException("Value not found.");
            }
            ESExtensionPoint.logException(expOrNull);
            throw new ESExtensionPointException(expOrNull);
        }
        return null;
    }

    protected static void logException(Exception e) {
        Activator.getDefault().logException("An exception occurred while using an ESExtensionPoint", e);
    }

    public int size() {
        return this.elements.size();
    }

    public String getId() {
        return this.id;
    }
}

