/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.AbstractAuthenticationControl;
import org.eclipse.emf.emfstore.internal.server.connection.ServerKeyStoreManager;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;

public class LDAPVerifier
extends AbstractAuthenticationControl {
    private final String ldapUrl;
    private final String ldapBase;
    private final String searchDn;
    private boolean useSSL;
    private static final String DEFAULT_CTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private final String authUser;
    private final String authPassword;

    public LDAPVerifier(String ldapUrl, String ldapBase, String searchDn, String authUser, String authPassword) {
        this.ldapUrl = ldapUrl;
        this.ldapBase = ldapBase;
        this.searchDn = searchDn;
        this.authUser = authUser;
        this.authPassword = authPassword;
        if (ldapUrl.startsWith("ldaps://")) {
            this.useSSL = true;
            ServerKeyStoreManager.getInstance().setJavaSSLProperties();
        }
    }

    public boolean verifyPassword(ACUser resolvedUser, String username, String password) throws AccessControlException {
        InitialDirContext dirContext = null;
        try {
            if (this.authUser != null && this.authPassword != null) {
                Properties authenticatedBind = this.authenticatedBind(this.authUser, this.authPassword);
                authenticatedBind.put("java.naming.security.principal", this.authUser);
                dirContext = new InitialDirContext(authenticatedBind);
            } else {
                dirContext = new InitialDirContext(this.anonymousBind());
            }
        }
        catch (NamingException e) {
            ModelUtil.logWarning((String)("LDAP Directory " + this.ldapUrl + " not found."), (Throwable)e);
            return false;
        }
        String resolvedName = this.resolveUser(username, dirContext);
        if (resolvedName == null) {
            return false;
        }
        try {
            dirContext = new InitialDirContext(this.authenticatedBind(resolvedName, password));
        }
        catch (NamingException e) {
            e.printStackTrace();
            ModelUtil.logWarning((String)("Login failed on " + this.ldapBase + " ."), (Throwable)e);
            return false;
        }
        return true;
    }

    private Properties anonymousBind() {
        Properties props = new Properties();
        props.put("java.naming.ldap.version", "3");
        props.put("java.naming.factory.initial", DEFAULT_CTX);
        props.put("java.naming.provider.url", this.ldapUrl);
        props.put("java.naming.ldap.factory.socket", "org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.LDAPSSLSocketFactory");
        if (this.useSSL()) {
            props.put("java.naming.security.protocol", "ssl");
        }
        return props;
    }

    private boolean useSSL() {
        return this.useSSL;
    }

    private Properties authenticatedBind(String principal, String credentials) {
        Properties bind = this.anonymousBind();
        bind.put("java.naming.security.authentication", "simple");
        bind.put("java.naming.security.credentials", credentials);
        return bind;
    }

    private String resolveUser(String username, DirContext dirContext) {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = null;
        try {
            results = dirContext.search(this.ldapBase, "(& (" + this.searchDn + "=" + username + ") (objectclass=*))", constraints);
        }
        catch (NamingException e) {
            ModelUtil.logWarning((String)("Search failed, base = " + this.ldapBase), (Throwable)e);
            return null;
        }
        if (results == null) {
            return null;
        }
        String resolvedName = null;
        try {
            SearchResult sr;
            if (results.hasMoreElements() && (sr = results.next()) != null) {
                resolvedName = sr.getName();
            }
        }
        catch (NamingException e) {
            ModelUtil.logException((String)("Search returned invalid results, base = " + this.ldapBase), (Throwable)e);
            return null;
        }
        if (resolvedName == null) {
            ModelUtil.logWarning((String)("Distinguished name not found on " + this.ldapBase));
            return null;
        }
        return resolvedName;
    }
}

