/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common;

import java.util.Locale;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.emfstore.internal.common.EMFStoreResource;

public class ESXMLResourceHelper
extends XMIHelperImpl {
    public ESXMLResourceHelper(EMFStoreResource resource) {
        super((XMLResource)resource);
    }

    public String convertToString(EFactory factory, EDataType dataType, Object value) {
        int classifierID = dataType.getClassifierID();
        if (ESXMLResourceHelper.isFloat(classifierID)) {
            return this.format((Float)value);
        }
        if (ESXMLResourceHelper.isDouble(classifierID)) {
            return this.format((Double)value);
        }
        return super.convertToString(factory, dataType, value);
    }

    private static boolean isFloat(int classifierID) {
        return classifierID == 37 || classifierID == 38;
    }

    private static boolean isDouble(int classifierID) {
        return classifierID == 31 || classifierID == 32;
    }

    private String format(Float value) {
        return String.format(Locale.US, "%f", Float.valueOf(value.floatValue()));
    }

    private String format(Double value) {
        return String.format(Locale.US, "%f", (double)value);
    }
}

