/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.filetransfer;

import java.io.File;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileTransferStatistics;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.FileNotOnServerException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.internal.server.model.FileIdentifier;

public final class FileDownloadStatus {
    private ProjectSpace transferringProjectSpace;
    private Observable finishedObservable = new Obs();
    private Observable failedObservable = new Obs();
    private FileTransferStatistics statistics = new FileTransferStatistics(this);
    private Status status;
    private File transferredFile;
    private FileIdentifier id;
    private Exception exception;
    public static final int NOT_AVAILABLE = -1;

    private FileDownloadStatus(ProjectSpace transferringProjectSpace, FileIdentifier id, Status status, File transferredFile) {
        this.transferringProjectSpace = transferringProjectSpace;
        this.status = status;
        this.id = id;
        this.transferredFile = transferredFile;
    }

    public FileIdentifier getFileIdentifier() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public void addTransferFinishedObserver(Observer o) {
        this.finishedObservable.addObserver(o);
        if (this.isTransferFinished()) {
            o.update(this.finishedObservable, this);
        }
    }

    public void addTransferFailedObserver(Observer o) {
        this.failedObservable.addObserver(o);
        if (this.status == Status.FAILED) {
            o.update(this.failedObservable, this);
        }
    }

    public void addDefaultFailObserver() {
        this.addTransferFailedObserver(new Observer(){

            public void update(Observable arg0, Object arg1) {
                FileDownloadStatus status = (FileDownloadStatus)arg1;
                Exception e = status.getException();
                ModelUtil.logException((String)"File transfer failed!", (Throwable)e);
            }
        });
    }

    public boolean isTransferFinished() {
        return this.status == Status.FINISHED;
    }

    public boolean isNotOnServer() {
        return this.status == Status.FAILED && this.getException() instanceof FileNotOnServerException;
    }

    public FileTransferStatistics getStatistics() {
        return this.statistics;
    }

    public File getTransferredFile() throws FileTransferException {
        if (this.isNotOnServer()) {
            throw new FileNotOnServerException(MessageFormat.format("File {0} has not been found on the server", this.id.getIdentifier()));
        }
        if (!this.isTransferFinished()) {
            throw new FileTransferException(MessageFormat.format("Trying to get transferred file {0} while transfer is not yet finished", this.id.getIdentifier()));
        }
        return this.transferredFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getTransferredFile(boolean block) throws FileTransferException {
        if (!this.isTransferFinished() && block) {
            Observer observer = new Observer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void update(Observable arg0, Object arg1) {
                    2 var3_3 = this;
                    synchronized (var3_3) {
                        this.notifyAll();
                    }
                }
            };
            this.addTransferFailedObserver(observer);
            this.addTransferFinishedObserver(observer);
            try {
                Observer observer2 = observer;
                synchronized (observer2) {
                    observer.wait();
                }
            }
            catch (InterruptedException e) {
                throw new FileTransferException("Failed to initialize blocked get.", (Throwable)e);
            }
        }
        return this.getTransferredFile();
    }

    public ProjectSpace getTransferringProjectSpace() {
        return this.transferringProjectSpace;
    }

    public Exception getException() {
        return this.exception;
    }

    void transferCancelled() {
        if (this.status == Status.FINISHED) {
            return;
        }
        this.statistics.registerStop();
        this.status = Status.CANCELLED;
    }

    void transferStarted(int fileSize) throws FileTransferException {
        if (this.status != Status.NOT_STARTED) {
            throw new FileTransferException("Cannot start a job that is " + this.status.name());
        }
        this.statistics.registerStart(fileSize);
        this.status = Status.TRANSFERING;
    }

    void transferFinished(File result) {
        this.status = Status.FINISHED;
        this.transferredFile = result;
        this.statistics.registerStop();
        this.finishedObservable.notifyObservers(this);
    }

    void transferFailed(Exception ex) {
        this.status = Status.FAILED;
        this.statistics.registerStop();
        this.exception = ex;
        this.failedObservable.notifyObservers(this);
    }

    /* synthetic */ FileDownloadStatus(ProjectSpace projectSpace, FileIdentifier fileIdentifier, Status status, File file, FileDownloadStatus fileDownloadStatus) {
        this(projectSpace, fileIdentifier, status, file);
    }

    static class Factory {
        Factory() {
        }

        public static FileDownloadStatus createAlreadyFinished(ProjectSpace p, FileIdentifier id, File transferredFile) {
            return new FileDownloadStatus(p, id, Status.FINISHED, transferredFile, null);
        }

        public static FileDownloadStatus createNew(ProjectSpace p, FileIdentifier id) {
            return new FileDownloadStatus(p, id, Status.NOT_STARTED, null, null);
        }
    }

    private static class Obs
    extends Observable {
        private Obs() {
        }

        public void notifyObservers(Object arg) {
            super.setChanged();
            super.notifyObservers(arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_STARTED,
        TRANSFERING,
        FINISHED,
        CANCELLED,
        FAILED;

    }
}

