/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.connectionmanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.emf.emfstore.client.exceptions.ESCertificateException;
import org.eclipse.emf.emfstore.client.provider.ESClientConfigurationProvider;
import org.eclipse.emf.emfstore.client.provider.ESKeyStoreManager;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyStoreManager
implements ESKeyStoreManager {
    public static final String KEYSTORENAME = "emfstoreClient.keystore";
    private static final String KEYSTOREPASSWORD = "654321";
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String CIPHER_ALGORITHM = "RSA";
    public static final String DEFAULT_CERTIFICATE = "emfstore test certificate (do not use in production!)";
    private static KeyStoreManager instance;
    private String defaultCertificate = null;
    private KeyStore keyStore;

    private KeyStoreManager() {
        this.setupKeys();
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        ESClientConfigurationProvider provider = (ESClientConfigurationProvider)new ESExtensionPoint("org.eclipse.emf.emfstore.client.defaultConfigurationProvider").getClass("providerClass", ESClientConfigurationProvider.class);
        if (provider == null) {
            return;
        }
        provider.initDefaultCertificates(this);
    }

    public static synchronized KeyStoreManager getInstance() {
        if (instance == null) {
            instance = new KeyStoreManager();
        }
        return instance;
    }

    public void setupKeys() {
        block13: {
            if (!this.keyStoreExists()) {
                File emfstoreDir = new File(Configuration.getFileInfo().getWorkspaceDirectory());
                if (!emfstoreDir.exists()) {
                    emfstoreDir.mkdir();
                }
                InputStream inputStream = this.getClass().getResourceAsStream(KEYSTORENAME);
                try {
                    try {
                        File clientKeyTarget = new File(String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()) + KEYSTORENAME);
                        FileUtil.copyFile((InputStream)inputStream, (File)clientKeyTarget);
                    }
                    catch (IOException iOException) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.setProperty("javax.net.ssl.trustStore", this.getPathToKeyStore());
        System.setProperty("javax.net.ssl.keyStore", this.getPathToKeyStore());
        System.setProperty("javax.net.ssl.keyStorePassword", KEYSTOREPASSWORD);
        System.setProperty("javax.net.ssl.trustStorePassword", KEYSTOREPASSWORD);
    }

    public ArrayList<String> getCertificates() throws ESCertificateException {
        this.loadKeyStore();
        ArrayList<String> certificates = new ArrayList<String>();
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String tmp = aliases.nextElement();
                certificates.add(tmp);
            }
        }
        catch (KeyStoreException e) {
            String message = "Loading certificates failed!";
            WorkspaceUtil.logException(message, e);
            throw new ESCertificateException(message, e);
        }
        return certificates;
    }

    public void deleteCertificate(String alias) throws ESCertificateException {
        if (this.isDefaultCertificate(alias)) {
            throw new ESCertificateException("Cannot delete default certificate!");
        }
        this.loadKeyStore();
        try {
            this.keyStore.deleteEntry(alias);
            this.storeKeyStore();
        }
        catch (KeyStoreException e) {
            String message = "Deleting certificate failed!";
            WorkspaceUtil.logException(message, e);
            throw new ESCertificateException(message, e);
        }
    }

    @Override
    public void addCertificate(String alias, String path) throws ESCertificateException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(path);
                this.addCertificate(alias, fileInputStream);
            }
            catch (FileNotFoundException e) {
                String message = "Storing certificate failed!";
                WorkspaceUtil.logException(message, e);
                throw new ESCertificateException(message, e);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    String message = "Storing certificate failed!";
                    WorkspaceUtil.logException(message, e);
                    throw new ESCertificateException(message, e);
                }
            }
        }
    }

    public void removeCertificate(String alias) throws ESCertificateException {
        try {
            this.keyStore.deleteEntry(alias);
            this.storeKeyStore();
        }
        catch (KeyStoreException e) {
            String message = "Keystore has not been initialized, or entry cannot be removed.";
            WorkspaceUtil.logException(message, e);
            throw new ESCertificateException(message, e);
        }
        catch (ESCertificateException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logException(message, e);
            throw new ESCertificateException(message, e);
        }
    }

    @Override
    public void addCertificate(String alias, InputStream certificate) throws ESCertificateException {
        if (!this.isDefaultCertificate(alias)) {
            this.loadKeyStore();
            try {
                CertificateFactory factory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
                Certificate newCertificate = factory.generateCertificate(certificate);
                this.keyStore.setCertificateEntry(alias, newCertificate);
                this.storeKeyStore();
            }
            catch (CertificateException certificateException) {
                String message = "Please choose a valid certificate!";
                throw new ESCertificateException(message);
            }
            catch (KeyStoreException e) {
                String message = "Storing certificate failed!";
                WorkspaceUtil.logException(message, e);
                throw new ESCertificateException(message, e);
            }
        }
    }

    private void storeKeyStore() throws ESCertificateException {
        this.loadKeyStore();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getPathToKeyStore());
            this.keyStore.store(fileOutputStream, KEYSTOREPASSWORD.toCharArray());
            fileOutputStream.close();
        }
        catch (KeyStoreException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new ESCertificateException(message, e);
        }
        catch (NoSuchAlgorithmException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new ESCertificateException(message, e);
        }
        catch (CertificateException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new ESCertificateException(message, e);
        }
        catch (FileNotFoundException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new ESCertificateException(message, e);
        }
        catch (IOException e) {
            String message = "Storing certificate failed!";
            WorkspaceUtil.logWarning(message, e);
            throw new ESCertificateException(message, e);
        }
    }

    public void reloadKeyStore() throws ESCertificateException {
        this.keyStore = null;
        this.loadKeyStore();
    }

    private void loadKeyStore() throws ESCertificateException {
        if (this.keyStore == null) {
            try {
                this.keyStore = KeyStore.getInstance("JKS");
                FileInputStream fileInputStream = new FileInputStream(this.getPathToKeyStore());
                this.keyStore.load(fileInputStream, KEYSTOREPASSWORD.toCharArray());
                fileInputStream.close();
            }
            catch (KeyStoreException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new ESCertificateException(message, e);
            }
            catch (NoSuchAlgorithmException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new ESCertificateException(message, e);
            }
            catch (CertificateException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new ESCertificateException(message, e);
            }
            catch (FileNotFoundException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new ESCertificateException(message, e);
            }
            catch (IOException e) {
                String message = "Loading certificate failed!";
                WorkspaceUtil.logWarning(message, e);
                throw new ESCertificateException(message, e);
            }
        }
    }

    public SSLContext getSSLContext() throws ESCertificateException {
        try {
            this.loadKeyStore();
            KeyManagerFactory managerFactory = KeyManagerFactory.getInstance("SunX509");
            managerFactory.init(this.keyStore, KEYSTOREPASSWORD.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(this.keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(managerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ESCertificateException("Loading certificate failed!", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new ESCertificateException("Loading certificate failed!", e);
        }
        catch (KeyStoreException e) {
            throw new ESCertificateException("Loading certificate failed!", e);
        }
        catch (KeyManagementException e) {
            throw new ESCertificateException("Loading certificate failed!", e);
        }
    }

    public boolean keyStoreExists() {
        File keyStore = new File(this.getPathToKeyStore());
        return keyStore.exists();
    }

    public String getPathToKeyStore() {
        return String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()) + KEYSTORENAME;
    }

    public String encrypt(String password, ServerInfo server) {
        try {
            Certificate publicKey = this.getCertificateForEncryption(server);
            PublicKey key = publicKey.getPublicKey();
            byte[] inpBytes = password.getBytes();
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, key);
            byte[] encryptededByteAr = cipher.doFinal(inpBytes);
            byte[] base64EncodedByteAr = Base64.encodeBase64((byte[])encryptededByteAr);
            return new String(base64EncodedByteAr);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (ESCertificateException e) {
            e.printStackTrace();
        }
        WorkspaceUtil.logException("Couldn't encrypt password.", new ESCertificateException("Couldn't encrypt password."));
        return "";
    }

    private Certificate getCertificateForEncryption(ServerInfo server) throws ESCertificateException {
        Certificate publicKey = server == null ? this.getCertificate(this.getDefaultCertificate()) : this.getCertificate(server.getCertificateAlias());
        if (publicKey == null && (publicKey = this.getCertificate(this.getDefaultCertificate())) == null) {
            throw new ESCertificateException("Unable to get certificate for password encryption.");
        }
        return publicKey;
    }

    public boolean isDefaultCertificate(String alias) {
        return this.getDefaultCertificate().equals(alias);
    }

    @Override
    public String getDefaultCertificate() {
        if (this.defaultCertificate != null) {
            return this.defaultCertificate;
        }
        if (Configuration.getVersioningInfo().isDeveloperVersion()) {
            return DEFAULT_CERTIFICATE;
        }
        return DEFAULT_CERTIFICATE;
    }

    public boolean contains(String alias) throws ESCertificateException {
        return this.getCertificate(alias) != null;
    }

    @Override
    public void setDefaultCertificate(String defaultCertificate) {
        this.defaultCertificate = defaultCertificate;
    }

    public Certificate getCertificate(String alias) throws ESCertificateException {
        if (alias == null) {
            return null;
        }
        this.loadKeyStore();
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ESCertificateException("Loading certificate failed!");
        }
    }

    @Override
    public boolean certificateExists(String alias) throws ESCertificateException {
        try {
            return this.getCertificate(alias) != null;
        }
        catch (ESCertificateException e) {
            if (!(e.getCause() instanceof FileNotFoundException)) {
                throw e;
            }
            return false;
        }
    }
}

