/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.importexport.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ProjectSpaceBasedExportController;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.util.ResourceHelper;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;

public class ExportProjectController
extends ProjectSpaceBasedExportController {
    public ExportProjectController(ProjectSpace projectSpace) {
        super(projectSpace);
    }

    public String[] getFilteredNames() {
        return new String[]{"EMFStore Project Files (*" + ExportImportDataUnits.Project.getExtension() + ")", "All Files (*.*)"};
    }

    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.Project.getExtension() + ", *.*"};
    }

    public String getLabel() {
        return "project";
    }

    public String getFilename() {
        PrimaryVersionSpec baseVersion = this.getProjectSpace().getBaseVersion();
        return String.valueOf(this.getProjectSpace().getProjectName()) + "@" + (baseVersion == null ? 0 : baseVersion.getIdentifier()) + ExportImportDataUnits.Project.getExtension();
    }

    public String getParentFolderPropertyKey() {
        return "org.eclipse.emf.emfstore.client.ui.exportProjectPath";
    }

    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        if (!FileUtil.getExtension((File)file).equals(ExportImportDataUnits.Project.getExtension())) {
            file = new File(file.getAbsoluteFile() + ExportImportDataUnits.Project.getExtension());
        }
        Project project = (Project)ModelUtil.clone((EObject)this.getProjectSpace().getProject());
        ResourceHelper.putElementIntoNewResource(file.getAbsolutePath(), project);
    }

    public boolean isExport() {
        return true;
    }
}

