/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.core.helper;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.Version;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryCache {
    private HashMap<ProjectId, HashMap<ModelElementId, TreeSet<Version>>> historyCache = new HashMap();

    public void initCache(List<ProjectHistory> projects) {
        for (ProjectHistory project : projects) {
            EList projectVersions = project.getVersions();
            if (projectVersions.size() <= 0) continue;
            HashMap<ModelElementId, TreeSet<Version>> initialHashMap = this.buildInitialHashMap((Version)projectVersions.get(0));
            for (Version version : projectVersions) {
                this.addChangePackageToCache(initialHashMap, version);
            }
            this.historyCache.put(project.getProjectId(), initialHashMap);
        }
    }

    public void addVersionToCache(ProjectId projectId, Version version) {
        HashMap<ModelElementId, TreeSet<Version>> hashMap = this.historyCache.get(projectId);
        if (hashMap != null & version != null) {
            this.addChangePackageToCache(hashMap, version);
        }
    }

    private void addChangePackageToCache(HashMap<ModelElementId, TreeSet<Version>> hashMap, Version version) {
        ChangePackage changes = version.getChanges();
        if (changes != null) {
            EList operations = changes.getOperations();
            this.extractOperations(hashMap, version, (EList<AbstractOperation>)operations);
        }
    }

    private void extractOperations(HashMap<ModelElementId, TreeSet<Version>> hashMap, Version version, EList<AbstractOperation> operations) {
        for (AbstractOperation abstractOperation : operations) {
            for (ModelElementId elementId : abstractOperation.getAllInvolvedModelElements()) {
                this.addModelElement(hashMap, version, elementId);
            }
        }
    }

    private void addModelElement(HashMap<ModelElementId, TreeSet<Version>> hashMap, Version version, ModelElementId id) {
        TreeSet<Version> set = hashMap.get(id);
        if (set == null) {
            set = this.getTreeSet();
            hashMap.put(id, set);
        }
        set.add(version);
    }

    private HashMap<ModelElementId, TreeSet<Version>> buildInitialHashMap(Version version) {
        Set allModelElements = version.getProjectState().getAllModelElements();
        HashMap<ModelElementId, TreeSet<Version>> hashMap = new HashMap<ModelElementId, TreeSet<Version>>((int)((double)allModelElements.size() * 1.15) + 1);
        for (EObject element : allModelElements) {
            hashMap.put(ModelUtil.getProject((EObject)element).getModelElementId(element), this.initVersionSet(version));
        }
        return hashMap;
    }

    private TreeSet<Version> initVersionSet(Version version) {
        TreeSet<Version> versionList = this.getTreeSet();
        versionList.add(version);
        return versionList;
    }

    public TreeSet<Version> getChangesForModelElement(ProjectId projectId, ModelElementId modelElementId) {
        HashMap<ModelElementId, TreeSet<Version>> map = this.historyCache.get(projectId);
        if (map == null) {
            return this.getTreeSet();
        }
        TreeSet<Version> hashSet = map.get(modelElementId);
        if (hashSet == null) {
            return this.getTreeSet();
        }
        return hashSet;
    }

    private TreeSet<Version> getTreeSet() {
        return new TreeSet<Version>(new Comparator<Version>(){

            @Override
            public int compare(Version o1, Version o2) {
                if (o1.getPrimarySpec().getIdentifier() == o2.getPrimarySpec().getIdentifier()) {
                    return 0;
                }
                if (o1.getPrimarySpec().getIdentifier() < o2.getPrimarySpec().getIdentifier()) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public void printMap() {
        for (ProjectId projectId : this.historyCache.keySet()) {
            System.out.println("PROJECT: " + projectId.getId());
            HashMap<ModelElementId, TreeSet<Version>> map = this.historyCache.get(projectId);
            for (ModelElementId meId : map.keySet()) {
                System.out.print("\tME: " + meId.getId() + " ");
                for (Version version : map.get(meId)) {
                    System.out.print(String.valueOf(version.getPrimarySpec().getIdentifier()) + ", ");
                }
                System.out.println("");
            }
        }
    }
}

