/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.navigator.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPProject;
import org.eclipse.emf.ecp.common.util.UiUtil;
import org.eclipse.emf.ecp.navigator.Activator;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicContainmentCommands
extends CompoundContributionItem {
    private static final String COMMAND_ID = "org.eclipse.emf.ecp.navigator.createContaiment";
    private EObject selectedME;
    private ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);

    protected IContributionItem[] getContributionItems() {
        this.selectedME = UiUtil.getSelectedEObject();
        if (this.selectedME == null) {
            return new IContributionItem[0];
        }
        try {
            if (ECPWorkspaceManager.getInstance().getWorkSpace().isRootObject(this.selectedME)) {
                return this.createNewWizard(this.selectedME.eClass());
            }
        }
        catch (NoWorkspaceException e) {
            Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
        }
        AdapterFactoryItemDelegator delegator = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory);
        List commandParameters = (List)delegator.getNewChildDescriptors((Object)this.selectedME, AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.selectedME), null);
        IContributionItem[] commands = this.createCommands(commandParameters);
        return commands;
    }

    private IContributionItem[] createNewWizard(EClass eClass) {
        ImageDescriptor imageDescriptor;
        CommandContributionItemParameter commandParam = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, "org.eclipse.emf.ecp.navigator.newModelElementWizard", 8);
        ArrayList<CommandContributionItem> commands = new ArrayList<CommandContributionItem>();
        HashMap<String, EClass> commandParams = new HashMap<String, EClass>();
        commandParams.put("org.eclipse.emf.ecp.navigator.eClassParameter", eClass);
        commandParam.label = "New Model Element";
        Image image = this.labelProvider.getImage((Object)eClass);
        commandParam.icon = imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        commandParam.parameters = commandParams;
        CommandContributionItem command = new CommandContributionItem(commandParam);
        commands.add(command);
        return commands.toArray(new IContributionItem[commands.size()]);
    }

    private IContributionItem[] createCommands(List<CommandParameter> commandParameters) {
        ArrayList<CommandContributionItem> commands = new ArrayList<CommandContributionItem>();
        HashMap<String, ArrayList<CommandParameter>> mapping = new HashMap<String, ArrayList<CommandParameter>>();
        for (CommandParameter commandParameter : commandParameters) {
            if (!(commandParameter.getValue() instanceof EObject)) continue;
            EClass eClass = ((EObject)commandParameter.getValue()).eClass();
            ArrayList<CommandParameter> list = (ArrayList<CommandParameter>)mapping.get(eClass.getName());
            if (list == null) {
                list = new ArrayList<CommandParameter>();
                mapping.put(eClass.getName(), list);
            }
            list.add(commandParameter);
        }
        for (String eclass : mapping.keySet()) {
            List list = (List)mapping.get(eclass);
            boolean showReferenceLable = list.size() > 1;
            for (CommandParameter commandParameter : list) {
                EReference containment = commandParameter.getEReference();
                if (!containment.isMany() && this.selectedME.eGet((EStructuralFeature)containment) != null) continue;
                try {
                    ECPProject project = ECPWorkspaceManager.getInstance().getWorkSpace().getProject(this.selectedME);
                    if (project != null && project.getMetaModelElementContext().isNonDomainElement(containment.getEReferenceType())) {
                        continue;
                    }
                }
                catch (NoWorkspaceException e) {
                    Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
                }
                CommandContributionItemParameter commandParam = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, COMMAND_ID, 8);
                HashMap<String, Object> commandParams = new HashMap<String, Object>();
                Object type = commandParameter.getValue();
                if (type instanceof EObject) {
                    commandParams.put("org.eclipse.emf.ecp.navigator.eClassParameter", ((EObject)type).eClass());
                    commandParams.put("org.eclipse.emf.ecp.navigator.eReferenceParameter", containment.getName());
                    commandParam.label = "New " + ((EObject)type).eClass().getName();
                    if (showReferenceLable) {
                        commandParam.label = String.valueOf(commandParam.label) + " (" + containment.getName() + ")";
                    }
                    commandParam.icon = this.getImage(((EObject)type).eClass());
                } else {
                    commandParams.put("org.eclipse.emf.ecp.navigator.eClassParameter", containment.getEReferenceType());
                    commandParam.label = "New " + containment.getEReferenceType().getName();
                    commandParam.icon = this.getImage(containment.getEReferenceType());
                }
                commandParam.parameters = commandParams;
                CommandContributionItem command = new CommandContributionItem(commandParam);
                commands.add(command);
            }
        }
        return commands.toArray(new IContributionItem[commands.size()]);
    }

    private ImageDescriptor getImage(EClass eClass) {
        EObject instance = eClass.getEPackage().getEFactoryInstance().create(eClass);
        Image image = this.labelProvider.getImage((Object)instance);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        return imageDescriptor;
    }

    public void dispose() {
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
        super.dispose();
    }
}

