/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.emfstore.client.model.ModelPackage;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.observers.LoginObserver;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.provider.ESBrowserContentProvider;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.provider.ESBrowserLabelProvider;
import org.eclipse.emf.emfstore.client.ui.views.emfstorebrowser.provider.ESBrowserViewerSorter;
import org.eclipse.emf.emfstore.common.observer.IObserver;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;

public class ESBrowserView
extends ViewPart
implements LoginObserver {
    private TreeViewer viewer;
    private ESBrowserContentProvider contentProvider;
    private MenuManager menuMgr;
    private AdapterImpl workspaceAdapter;
    private Map<ServerInfo, AdapterImpl> serverInfoAdapterMap = new HashMap<ServerInfo, AdapterImpl>();

    public ESBrowserView() {
        Workspace currentWorkspace = WorkspaceManager.getInstance().getCurrentWorkspace();
        WorkspaceManager.getObserverBus().register((IObserver)this);
        for (ServerInfo serverInfo : currentWorkspace.getServerInfos()) {
            ServerInfoAdapter serverInfoAdapter = new ServerInfoAdapter(serverInfo);
            serverInfo.eAdapters().add((Object)serverInfoAdapter);
            this.serverInfoAdapterMap.put(serverInfo, serverInfoAdapter);
        }
        this.workspaceAdapter = new WorkspaceAdapter();
        currentWorkspace.eAdapters().add((Object)this.workspaceAdapter);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 772);
        this.contentProvider = new ESBrowserContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ESBrowserLabelProvider(), decoratorManager.getLabelDecorator()));
        this.viewer.setSorter((ViewerSorter)new ESBrowserViewerSorter());
        this.viewer.setInput((Object)WorkspaceManager.getInstance().getCurrentWorkspace());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.emf.emfstore.client.ui.views.RepositoryView");
        this.menuMgr = new MenuManager();
        this.menuMgr.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = this.menuMgr.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookDoubleClickAction();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object firstElement = ((IStructuredSelection)ESBrowserView.this.viewer.getSelection()).getFirstElement();
                ESBrowserView.this.viewer.refresh(firstElement);
                ESBrowserView.this.viewer.expandToLevel(firstElement, 1);
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void loginCompleted(final Usersession session) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ESBrowserView.this.viewer.refresh((Object)session.getServerInfo(), true);
            }
        });
    }

    public void dispose() {
        super.dispose();
        Workspace currentWorkspace = WorkspaceManager.getInstance().getCurrentWorkspace();
        currentWorkspace.eAdapters().remove((Object)this.workspaceAdapter);
        WorkspaceManager.getObserverBus().unregister((IObserver)this);
        for (ServerInfo s : currentWorkspace.getServerInfos()) {
            s.eAdapters().remove((Object)this.serverInfoAdapterMap.get(s));
        }
    }

    private final class ServerInfoAdapter
    extends AdapterImpl {
        private final ServerInfo serverInfo;

        private ServerInfoAdapter(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
        }

        public void notifyChanged(final Notification msg) {
            if (msg.getFeature() != null && msg.getFeature().equals(ModelPackage.eINSTANCE.getServerInfo_ProjectInfos())) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        if (msg.getEventType() == 6 || msg.getEventType() == 4) {
                            ESBrowserView.this.viewer.collapseToLevel((Object)ServerInfoAdapter.this.serverInfo, 0);
                        }
                        ESBrowserView.this.viewer.refresh((Object)ServerInfoAdapter.this.serverInfo, true);
                        IEvaluationService service = (IEvaluationService)ESBrowserView.this.getSite().getService(IEvaluationService.class);
                        service.requestEvaluation("org.eclipse.emf.emfstore.client.ui.commands.ServerInfoIsLoggedIn");
                    }
                });
            }
        }
    }

    private final class WorkspaceAdapter
    extends AdapterImpl {
        private WorkspaceAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNewValue() instanceof ServerInfo) {
                ServerInfo serverInfo = (ServerInfo)msg.getNewValue();
                ServerInfoAdapter serverInfoAdapter = new ServerInfoAdapter(serverInfo);
                serverInfo.eAdapters().add((Object)serverInfoAdapter);
                ESBrowserView.this.serverInfoAdapterMap.put(serverInfo, serverInfoAdapter);
                ESBrowserView.this.viewer.refresh();
            } else if (msg.getOldValue() instanceof ServerInfo) {
                ServerInfo serverInfo = (ServerInfo)msg.getOldValue();
                serverInfo.eAdapters().remove(ESBrowserView.this.serverInfoAdapterMap.get(serverInfo));
                ESBrowserView.this.viewer.refresh();
            }
            super.notifyChanged(msg);
        }
    }
}

