/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.controller;

import java.util.List;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.controller.callbacks.UpdateCallback;
import org.eclipse.emf.emfstore.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.client.model.observers.ConflictResolver;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.client.ui.dialogs.UpdateDialog;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.MergeProjectHandler;
import org.eclipse.emf.emfstore.client.ui.handlers.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUpdateProjectController
extends AbstractEMFStoreUIController
implements UpdateCallback {
    public UIUpdateProjectController(Shell shell) {
        super(shell);
    }

    public void update(ProjectSpace projectSpace) throws EmfStoreException {
        this.update(projectSpace, null);
    }

    public void update(ProjectSpace projectSpace, VersionSpec version) throws EmfStoreException {
        try {
            this.openProgress();
            PrimaryVersionSpec oldBaseVersion = projectSpace.getBaseVersion();
            PrimaryVersionSpec updatedVersion = projectSpace.update(version, (UpdateCallback)this, this.getProgressMonitor());
            if (oldBaseVersion.equals(updatedVersion)) {
                this.noChangesOnServer();
            }
        }
        finally {
            this.closeProgress();
        }
    }

    public void askForVersionAndUpdate(ProjectSpace projectSpace) throws EmfStoreException {
        this.update(projectSpace, this.openVersionDialog(projectSpace));
    }

    protected VersionSpec openVersionDialog(ProjectSpace projectSpace) {
        return null;
    }

    public void noChangesOnServer() {
        this.closeProgress();
        MessageDialog.openInformation((Shell)this.getShell(), (String)"No need to update", (String)"Your project is up to date, you do not need to update.");
    }

    public boolean conflictOccurred(ChangeConflictException conflictException) {
        ProjectSpace projectSpace = conflictException.getProjectSpace();
        boolean mergeSuccessful = false;
        try {
            PrimaryVersionSpec targetVersion = projectSpace.resolveVersionSpec(VersionSpec.HEAD_VERSION);
            mergeSuccessful = projectSpace.merge(targetVersion, (ConflictResolver)new MergeProjectHandler(conflictException));
        }
        catch (EmfStoreException e) {
            WorkspaceUtil.logException((String)"Exception when merging the project!", (Exception)((Object)e));
            this.handleException((Exception)((Object)e));
        }
        this.closeProgress();
        return mergeSuccessful;
    }

    public boolean inspectChanges(ProjectSpace projectSpace, List<ChangePackage> changePackages) {
        UpdateDialog updateDialog = new UpdateDialog(this.getShell(), projectSpace, changePackages);
        return updateDialog.open() == 0;
    }

    public void updateCompleted(ProjectSpace projectSpace, PrimaryVersionSpec oldVersion, PrimaryVersionSpec newVersion) {
        this.closeProgress();
    }
}

