/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.controller;

import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.controller.callbacks.CommitCallback;
import org.eclipse.emf.emfstore.client.ui.controller.UIUpdateProjectController;
import org.eclipse.emf.emfstore.client.ui.dialogs.CommitDialog;
import org.eclipse.emf.emfstore.client.ui.handlers.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class UICommitProjectController
extends AbstractEMFStoreUIController
implements CommitCallback {
    public UICommitProjectController(Shell shell) {
        super(shell);
    }

    public PrimaryVersionSpec commit(ProjectSpace projectSpace) throws EmfStoreException {
        return this.commit(projectSpace, null);
    }

    public PrimaryVersionSpec commit(ProjectSpace projectSpace, LogMessage logMessage) throws EmfStoreException {
        this.openProgress();
        PrimaryVersionSpec commit = projectSpace.commit(logMessage, (CommitCallback)this, this.getProgressMonitor());
        this.closeProgress();
        return commit;
    }

    public void noLocalChanges(ProjectSpace projectSpace) {
        MessageDialog.openInformation((Shell)this.getShell(), null, (String)"No local changes in your project. No need to commit.");
        this.closeProgress();
    }

    public boolean baseVersionOutOfDate(ProjectSpace projectSpace) {
        String message = "Your project is outdated, you need to update before commit. Do you want to update now?";
        if (this.confirmationDialog(message)) {
            try {
                new UIUpdateProjectController(this.getShell()).update(projectSpace);
            }
            catch (EmfStoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.closeProgress();
        return true;
    }

    public boolean inspectChanges(ProjectSpace projectSpace, ChangePackage changePackage) {
        if (changePackage.getOperations().isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"No local changes", (String)"Your local changes were mutually exclusive.\nThey are no changes pending for commit.");
            return false;
        }
        CommitDialog commitDialog = new CommitDialog(this.getShell(), changePackage, projectSpace);
        if (commitDialog.open() == 0) {
            changePackage.getLogMessage().setMessage(commitDialog.getLogText());
            return true;
        }
        return false;
    }
}

