/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.model.versioning.operations.util;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CreateDeleteOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationsCanonizer {
    private OperationsCanonizer() {
    }

    public static void canonize(List<AbstractOperation> operations) {
        try {
            OperationsCanonizer.foldComposites(operations);
            OperationsCanonizer.foldAttributes(operations);
            OperationsCanonizer.foldAttributesIntoCreates(operations);
            OperationsCanonizer.foldAttributesIntoDeletes(operations);
            OperationsCanonizer.foldCreatesAndDeletes(operations);
        }
        catch (RuntimeException e) {
            ModelUtil.log((String)("Runtime exception in " + OperationsCanonizer.class.getName()), (Throwable)e, (int)4);
        }
    }

    private static void foldCreatesAndDeletes(List<AbstractOperation> operations) {
        int i = 0;
        while (i < operations.size() - 1) {
            CreateDeleteOperation deleteOp;
            AbstractOperation opRight;
            CreateDeleteOperation createOp;
            AbstractOperation opLeft = operations.get(i);
            if (opLeft instanceof CreateDeleteOperation && !(createOp = (CreateDeleteOperation)opLeft).isDelete() && (opRight = operations.get(i + 1)) instanceof CreateDeleteOperation && (deleteOp = (CreateDeleteOperation)opRight).isDelete() && createOp.getModelElementId().equals(deleteOp.getModelElementId())) {
                operations.remove(i + 1);
                operations.remove(i);
                i = Math.max(0, i - 2);
            }
            ++i;
        }
    }

    private static void foldAttributesIntoCreates(List<AbstractOperation> operations) {
        int i = 0;
        while (i < operations.size() - 1) {
            CreateDeleteOperation createOp;
            AbstractOperation opLeft = operations.get(i);
            if (opLeft instanceof CreateDeleteOperation && !(createOp = (CreateDeleteOperation)opLeft).isDelete()) {
                int j = i + 1;
                while (j < operations.size()) {
                    AbstractOperation opRight = operations.get(j);
                    if (opRight instanceof AttributeOperation && opLeft.getModelElementId().equals(opRight.getModelElementId())) {
                        AttributeOperation attOp = (AttributeOperation)opRight;
                        EStructuralFeature feature = createOp.getModelElement().eClass().getEStructuralFeature(attOp.getFeatureName());
                        createOp.getModelElement().eSet(feature, attOp.getNewValue());
                        operations.remove(j);
                        --j;
                    }
                    if (opRight instanceof CompositeOperation && OperationsCanonizer.containsAttributeChangeTo((CompositeOperation)opRight, createOp.getModelElementId())) break;
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void foldAttributesIntoDeletes(List<AbstractOperation> operations) {
        int i = operations.size() - 1;
        while (i > 0 && i < operations.size()) {
            CreateDeleteOperation deleteOp;
            AbstractOperation opRight = operations.get(i);
            if (opRight instanceof CreateDeleteOperation && (deleteOp = (CreateDeleteOperation)opRight).isDelete()) {
                int j = i - 1;
                while (j >= 0) {
                    AbstractOperation opLeft = operations.get(j);
                    if (opLeft instanceof AttributeOperation && opRight.getModelElementId().equals(opLeft.getModelElementId())) {
                        AttributeOperation attOp = (AttributeOperation)opLeft;
                        EStructuralFeature feature = deleteOp.getModelElement().eClass().getEStructuralFeature(attOp.getFeatureName());
                        deleteOp.getModelElement().eSet(feature, attOp.getOldValue());
                        operations.remove(j);
                        --i;
                    }
                    if (opLeft instanceof CompositeOperation && OperationsCanonizer.containsAttributeChangeTo((CompositeOperation)opLeft, deleteOp.getModelElementId())) break;
                    --j;
                }
            }
            --i;
        }
    }

    private static boolean containsAttributeChangeTo(CompositeOperation comp, ModelElementId modelElementId) {
        for (AbstractOperation op : comp.getSubOperations()) {
            if (!(op instanceof AttributeOperation) || !modelElementId.equals(op.getModelElementId())) continue;
            return true;
        }
        return false;
    }

    private static void foldComposites(List<AbstractOperation> operations) {
        LinkedList<CompositeOperation> emptyComposites = new LinkedList<CompositeOperation>();
        for (AbstractOperation op : operations) {
            if (!(op instanceof CompositeOperation)) continue;
            CompositeOperation comp = (CompositeOperation)op;
            AbstractOperation operationCopy = null;
            if (comp.getMainOperation() != null) {
                operationCopy = (AbstractOperation)ModelUtil.clone((EObject)comp);
            }
            OperationsCanonizer.canonize(comp.getSubOperations());
            if (comp.getSubOperations().size() == 0) {
                emptyComposites.add(comp);
                continue;
            }
            if (comp.getMainOperation() == null || comp.getSubOperations().contains((Object)comp.getMainOperation())) continue;
            CompositeOperation restored = (CompositeOperation)operationCopy;
            comp.getSubOperations().clear();
            comp.getSubOperations().addAll(restored.getSubOperations());
            comp.setMainOperation(restored.getMainOperation());
        }
        operations.removeAll(emptyComposites);
    }

    private static void foldAttributes(List<AbstractOperation> operations) {
        int i = 0;
        while (i < operations.size() - 1) {
            AbstractOperation opLeft = operations.get(i);
            if (opLeft instanceof AttributeOperation) {
                AttributeOperation attOpLeft = (AttributeOperation)opLeft;
                int j = i + 1;
                while (j < operations.size()) {
                    AbstractOperation opRight = operations.get(j);
                    if (opRight instanceof AttributeOperation && opLeft.getModelElementId().equals(opRight.getModelElementId())) {
                        AttributeOperation attOpRight = (AttributeOperation)opRight;
                        if (attOpLeft.getFeatureName().equals(attOpRight.getFeatureName())) {
                            attOpLeft.setNewValue(attOpRight.getNewValue());
                            operations.remove(j);
                            --j;
                        }
                    }
                    if (opRight instanceof CreateDeleteOperation || opRight instanceof CompositeOperation) break;
                    ++j;
                }
                if (attOpLeft.getNewValue() == null && attOpLeft.getOldValue() == null || attOpLeft.getNewValue() != null && attOpLeft.getNewValue().equals(attOpLeft.getOldValue())) {
                    operations.remove(i);
                    --i;
                }
            }
            ++i;
        }
    }
}

