/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.model.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPointException;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.model.provider.AbstractOperationCustomLabelProvider;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomOperationLabelProviderManager {
    private static List<AbstractOperationCustomLabelProvider> list;
    private final Map<ModelElementId, EObject> modelElementMap;

    public CustomOperationLabelProviderManager(Map<ModelElementId, EObject> modelElementMap) {
        this.modelElementMap = modelElementMap;
        if (list == null) {
            this.initExtensions();
        }
    }

    public AbstractOperationCustomLabelProvider getCustomLabelProvider(AbstractOperation operation) {
        AbstractOperationCustomLabelProvider highestVisualizer = null;
        int highestNumber = 0;
        int currentRenderState = 0;
        for (AbstractOperationCustomLabelProvider changePackageVisualizer : list) {
            currentRenderState = changePackageVisualizer.canRender(operation);
            if (currentRenderState <= highestNumber) continue;
            highestNumber = currentRenderState;
            highestVisualizer = changePackageVisualizer;
        }
        return highestVisualizer;
    }

    private void initExtensions() {
        list = new ArrayList<AbstractOperationCustomLabelProvider>();
        for (ExtensionElement element : new ExtensionPoint("org.eclipse.emf.emfstore.server.model.edit.customOperationLabelProvider", true).getExtensionElements()) {
            try {
                AbstractOperationCustomLabelProvider provider = (AbstractOperationCustomLabelProvider)element.getClass("class", AbstractOperationCustomLabelProvider.class);
                provider.setModelElementMap(this.modelElementMap);
                list.add(provider);
            }
            catch (ExtensionPointException e) {
                ModelUtil.logException((String)"Exception occured while initializing custom label provider extensions!", (Throwable)e);
            }
        }
    }
}

