/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model;

import org.eclipse.emf.emfstore.client.model.ModelFactory;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;

public final class LoginUtil {
    private LoginUtil() {
    }

    public static void login(Usersession session) throws AccessControlException, EmfStoreException {
        session.logIn();
    }

    public static void logout(Usersession session) throws EmfStoreException {
        session.logout();
    }

    public static ServerInfo createServerInfo(String name, String url, int port, String alias) {
        ServerInfo serverInfo = ModelFactory.eINSTANCE.createServerInfo();
        serverInfo.setName(name);
        serverInfo.setUrl(url);
        serverInfo.setPort(port);
        serverInfo.setCertificateAlias(alias);
        return serverInfo;
    }

    public static Usersession createUsersession(String name, String password, ServerInfo serverInfo) {
        Usersession usersession = ModelFactory.eINSTANCE.createUsersession();
        usersession.setUsername(name);
        usersession.setPassword(password);
        usersession.setServerInfo(serverInfo);
        return usersession;
    }
}

