/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NotImplementedException;

public class VerifyRequestManager {
    private static final int ALLOWED_FAILED_REQUESTS_BEFORE_RETRY = 4;
    private final Map<String, Integer> failedAttemptsCount;

    public VerifyRequestManager(int delay) {
        Cache cache = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterWrite((long)delay, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, Integer>(){

            public Integer load(String key) throws Exception {
                throw new NotImplementedException();
            }
        });
        this.failedAttemptsCount = cache.asMap();
    }

    public synchronized void cleanupFailedAttempts(String username) {
        this.failedAttemptsCount.remove(username);
    }

    public synchronized void recordFailedVerifyUserAttempt(String username) {
        Integer count = this.failedAttemptsCount.get(username);
        if (count == null) {
            count = 0;
        }
        this.failedAttemptsCount.put(username, count + 1);
    }

    public synchronized boolean checkTooManyFailedRequests(String username) {
        Integer count = this.failedAttemptsCount.get(username);
        if (count == null) {
            return false;
        }
        return count > 4;
    }
}

