/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.decorator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectPreDeleteObserver;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.emfstore.internal.ui.decorator.EMFStoreDirtyDecoratorCachedTree;
import org.eclipse.emf.ecp.emfstore.internal.ui.decorator.EMFStoreDirtyObserver;
import org.eclipse.emf.ecp.emfstore.internal.ui.e3.Activator;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.observer.ESCommitObserver;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.observers.OperationObserver;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class EMFStoreDirtyDecorator
implements ILightweightLabelDecorator,
ESCommitObserver,
ECPProjectPreDeleteObserver {
    public static final String dirtyPath = "icons/dirty.png";
    private static Map<ECPProject, EMFStoreDirtyObserver> observers = new HashMap<ECPProject, EMFStoreDirtyObserver>();

    public EMFStoreDirtyDecorator() {
        ECPUtil.getECPObserverBus().register((ECPObserver)this);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof ECPProject) {
            InternalProject project = (InternalProject)element;
            if (ECPUtil.getECPProjectManager().getProject(project.getName()) == null) {
                return;
            }
            ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)EMFStoreProvider.INSTANCE.getProjectSpace(project)).toInternalAPI();
            if (!observers.containsKey(element)) {
                EMFStoreDirtyObserver emfStoreDirtyObserver = new EMFStoreDirtyObserver(projectSpace, project);
                projectSpace.getOperationManager().addOperationObserver((OperationObserver)emfStoreDirtyObserver);
                observers.put((ECPProject)element, emfStoreDirtyObserver);
            }
            if (project.isOpen() && projectSpace.isShared() && observers.get(element).isDirty()) {
                decoration.addOverlay(Activator.getImageDescriptor(dirtyPath), 2);
            }
        } else if (element instanceof EObject) {
            InternalProject project = null;
            try {
                project = (InternalProject)ECPUtil.getECPProjectManager().getProject(element);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (project != null && project.isOpen() && EMFStoreProvider.INSTANCE.getProjectSpace(project).isShared() && (Integer)EMFStoreDirtyDecoratorCachedTree.getInstance((ECPProject)project).getCachedValue(element) > 0) {
                decoration.addOverlay(Activator.getImageDescriptor(dirtyPath), 2);
            } else {
                decoration.addOverlay(null);
            }
            return;
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean inspectChanges(ESLocalProject localProject, ESChangePackage changePackage, IProgressMonitor monitor) {
        return true;
    }

    public void commitCompleted(ESLocalProject localProject, ESPrimaryVersionSpec newRevision, IProgressMonitor monitor) {
        ECPProject project = EMFStoreProvider.INSTANCE.getProject(localProject);
        EMFStoreDirtyDecoratorCachedTree.getInstance(project).clear();
        observers.get(project).clearObserverCache();
    }

    public void projectDelete(ECPProject project) {
        EMFStoreDirtyDecoratorCachedTree.removeProject(project);
        observers.remove(project);
    }
}

