/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.swt.util.SWTValidationHelper;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.model.DomainModelReferenceChangeListener;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.mandatory.model.VTMandatoryFactory;
import org.eclipse.emf.ecp.view.template.style.mandatory.model.VTMandatoryStyleProperty;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public abstract class AbstractControlSWTRenderer<VCONTROL extends VControl>
extends AbstractSWTRenderer<VCONTROL> {
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private ComposedAdapterFactory composedAdapterFactory;
    private DataBindingContext dataBindingContext;
    private IObservableValue modelValue;
    private final WritableValue value = new WritableValue();
    private DomainModelReferenceChangeListener domainModelReferenceChangeListener;

    public AbstractControlSWTRenderer() {
    }

    AbstractControlSWTRenderer(SWTRendererFactory factory) {
        super(factory);
    }

    protected void postInit() {
        super.postInit();
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        this.domainModelReferenceChangeListener = new DomainModelReferenceChangeListener(){

            public void notifyChange() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!AbstractControlSWTRenderer.this.value.isDisposed()) {
                            AbstractControlSWTRenderer.this.updateControl();
                        }
                    }
                });
            }
        };
        ((VControl)this.getVElement()).getDomainModelReference().getChangeListener().add((Object)this.domainModelReferenceChangeListener);
        this.updateControl();
    }

    protected void dispose() {
        if (((VControl)this.getVElement()).getDomainModelReference() != null) {
            ((VControl)this.getVElement()).getDomainModelReference().getChangeListener().remove((Object)this.domainModelReferenceChangeListener);
        }
        this.domainModelReferenceChangeListener = null;
        if (this.value != null) {
            this.value.dispose();
        }
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
            this.composedAdapterFactory = null;
        }
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
            this.dataBindingContext = null;
        }
        if (this.modelValue != null) {
            this.modelValue.dispose();
            this.modelValue = null;
        }
        super.dispose();
    }

    protected final Image getValidationIcon(int severity) {
        return SWTValidationHelper.INSTANCE.getValidationIcon(severity, this.getVElement(), this.getViewModelContext());
    }

    protected final Color getValidationBackgroundColor(int severity) {
        return SWTValidationHelper.INSTANCE.getValidationBackgroundColor(severity, this.getVElement(), this.getViewModelContext());
    }

    protected final IItemPropertyDescriptor getItemPropertyDescriptor(EStructuralFeature.Setting setting) {
        if (setting == null) {
            return null;
        }
        IItemPropertyDescriptor descriptor = this.adapterFactoryItemDelegator.getPropertyDescriptor((Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
        return descriptor;
    }

    protected final DataBindingContext getDataBindingContext() {
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new EMFDataBindingContext();
        }
        return this.dataBindingContext;
    }

    protected final IObservableValue getModelValue(EStructuralFeature.Setting setting) {
        if (this.modelValue == null) {
            this.modelValue = EMFEditProperties.value((EditingDomain)this.getEditingDomain(setting), (EStructuralFeature)setting.getEStructuralFeature()).observeDetail((IObservableValue)this.value);
        }
        return this.modelValue;
    }

    protected final EditingDomain getEditingDomain(EStructuralFeature.Setting setting) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)setting.getEObject());
    }

    protected final Control createLabel(Composite parent) throws NoPropertyDescriptorFoundExeption {
        EStructuralFeature.Setting setting;
        Label label = null;
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.LEFT && ((VControl)this.getVElement()).getDomainModelReference().getIterator().hasNext() && (setting = (EStructuralFeature.Setting)((VControl)this.getVElement()).getDomainModelReference().getIterator().next()) != null) {
            String labelText;
            IItemPropertyDescriptor itemPropertyDescriptor = this.getItemPropertyDescriptor(setting);
            if (itemPropertyDescriptor == null) {
                throw new NoPropertyDescriptorFoundExeption(setting.getEObject(), setting.getEStructuralFeature());
            }
            label = new Label(parent, 0);
            label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
            label.setBackground(parent.getBackground());
            String extra = "";
            VTMandatoryStyleProperty mandatoryStyle = this.getMandatoryStyle();
            if (mandatoryStyle.isHighliteMandatoryFields() && setting.getEStructuralFeature().getLowerBound() > 0) {
                extra = mandatoryStyle.getMandatoryMarker();
            }
            if ((labelText = itemPropertyDescriptor.getDisplayName((Object)setting.getEObject())) != null && labelText.trim().length() != 0) {
                label.setText(String.valueOf(labelText) + extra);
                label.setToolTipText(itemPropertyDescriptor.getDescription((Object)setting.getEObject()));
            }
        }
        return label;
    }

    private VTMandatoryStyleProperty getMandatoryStyle() {
        VTViewTemplateProvider vtViewTemplateProvider = Activator.getDefault().getVTViewTemplateProvider();
        if (vtViewTemplateProvider == null) {
            return this.getDefaultStyle();
        }
        Set styleProperties = vtViewTemplateProvider.getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTMandatoryStyleProperty.class.isInstance(styleProperty)) continue;
            return (VTMandatoryStyleProperty)styleProperty;
        }
        return this.getDefaultStyle();
    }

    private VTMandatoryStyleProperty getDefaultStyle() {
        return VTMandatoryFactory.eINSTANCE.createMandatoryStyleProperty();
    }

    protected final Label createValidationIcon(Composite composite) {
        Label validationLabel = new Label(composite, 0);
        validationLabel.setBackground(composite.getBackground());
        return validationLabel;
    }

    private void updateControl() {
        Iterator settings = ((VControl)this.getVElement()).getDomainModelReference().getIterator();
        if (settings.hasNext()) {
            this.value.setValue((Object)((EStructuralFeature.Setting)settings.next()).getEObject());
            this.applyEnable();
        } else {
            this.value.setValue(null);
            for (Map.Entry entry : this.getControls().entrySet()) {
                this.setControlEnabled((SWTGridCell)entry.getKey(), (Control)entry.getValue(), false);
            }
        }
    }
}

