/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.validation.Activator;
import org.eclipse.emf.ecp.view.internal.validation.ECPSubstitutionLabelProvider;
import org.eclipse.emf.ecp.view.internal.validation.ValidationNotification;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.validation.ValidationProvider;
import org.eclipse.emf.ecp.view.spi.validation.ValidationService;
import org.eclipse.emf.ecp.view.spi.validation.ViewValidationListener;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;

public class ValidationServiceImpl
implements ValidationService {
    private final Set<ValidationProvider> validationProviders = new LinkedHashSet<ValidationProvider>();
    private ValidationDomainModelChangeListener domainChangeListener;
    private ViewModelChangeListener viewChangeListener;
    private ViewModelContext context;
    private final Queue<EObject> validationQueue = new LinkedList<EObject>();
    private final Set<EObject> validated = new LinkedHashSet<EObject>();
    private boolean validationRunning;
    private final Map<UniqueSetting, VDiagnostic> currentUpdates = new LinkedHashMap<UniqueSetting, VDiagnostic>();
    private final Set<ViewValidationListener> validationListeners = new LinkedHashSet<ViewValidationListener>();

    public void instantiate(ViewModelContext context) {
        this.context = context;
        VElement renderable = context.getViewModel();
        if (renderable == null) {
            throw new IllegalStateException("View model must not be null");
        }
        EObject domainModel = context.getDomainModel();
        if (domainModel == null) {
            throw new IllegalStateException("Domain model must not be null");
        }
        this.readValidationProvider();
        this.domainChangeListener = new ValidationDomainModelChangeListener();
        this.viewChangeListener = new ViewModelChangeListener();
        context.registerDomainChangeListener((ModelChangeListener)this.domainChangeListener);
        context.registerViewChangeListener((ModelChangeListener)this.viewChangeListener);
        this.validate(this.getAllEObjects(domainModel));
    }

    private void cleanControlDiagnostics(EObject parent, EReference parentReference, EObject removedEObject) {
        Set controls = this.context.getControlsFor(UniqueSetting.createSetting((EObject)parent, (EStructuralFeature)parentReference));
        if (controls == null) {
            return;
        }
        for (VElement vControl : controls) {
            if (vControl == null || vControl.getDiagnostic() == null) continue;
            LinkedHashSet<Diagnostic> diagnosticsToRemove = new LinkedHashSet<Diagnostic>();
            for (Object diagnosticObject : vControl.getDiagnostic().getDiagnostics()) {
                Diagnostic diagnostic = (Diagnostic)Diagnostic.class.cast(diagnosticObject);
                if (diagnostic.getData().size() < 1 || !removedEObject.equals(diagnostic.getData().get(0))) continue;
                diagnosticsToRemove.add(diagnostic);
            }
            vControl.getDiagnostic().getDiagnostics().removeAll(diagnosticsToRemove);
        }
    }

    private void readValidationProvider() {
        IConfigurationElement[] controls;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.validation.validationProvider");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ValidationProvider validationProvider = (ValidationProvider)e.createExecutableExtension("class");
                this.validationProviders.add(validationProvider);
            }
            catch (CoreException e1) {
                Activator.logException((Exception)((Object)e1));
            }
            ++n2;
        }
    }

    public void dispose() {
        this.context.unregisterDomainChangeListener((ModelChangeListener)this.domainChangeListener);
        this.context.unregisterViewChangeListener((ModelChangeListener)this.viewChangeListener);
    }

    public int getPriority() {
        return 3;
    }

    private Collection<EObject> getAllEObjects(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(eObject);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)false);
        while (iterator.hasNext()) {
            result.add((EObject)iterator.next());
        }
        return result;
    }

    @Override
    public void validate(Collection<EObject> eObjects) {
        for (EObject eObject : eObjects) {
            if (this.validated.contains(eObject)) continue;
            this.validated.add(eObject);
            this.validationQueue.offer(eObject);
        }
        this.processValidationQueue();
    }

    public void validate(EObject eObject) {
        if (!this.validated.contains(eObject)) {
            this.validated.add(eObject);
            this.validationQueue.offer(eObject);
            this.processValidationQueue();
        }
    }

    private void processValidationQueue() {
        EObject toValidate;
        if (this.validationRunning) {
            return;
        }
        this.validationRunning = true;
        while ((toValidate = this.validationQueue.poll()) != null) {
            this.validateAndCollectSettings(toValidate);
        }
        this.update();
        this.notifyListeners();
        this.currentUpdates.clear();
        this.validated.clear();
        this.validationRunning = false;
    }

    public void notifyListeners() {
        if (this.validationListeners.size() > 0) {
            Set<Diagnostic> result = this.getDiagnosticResult();
            for (ViewValidationListener l : this.validationListeners) {
                l.onNewValidation(result);
            }
        }
    }

    private void update() {
        LinkedHashMap<VElement, VDiagnostic> controlDiagnosticMap = new LinkedHashMap<VElement, VDiagnostic>();
        for (UniqueSetting uniqueSetting : this.currentUpdates.keySet()) {
            Set controls = this.context.getControlsFor(uniqueSetting);
            if (controls == null) continue;
            for (VElement control : controls) {
                if (!controlDiagnosticMap.containsKey(control)) {
                    controlDiagnosticMap.put(control, VViewFactory.eINSTANCE.createDiagnostic());
                }
                ((VDiagnostic)controlDiagnosticMap.get(control)).getDiagnostics().removeAll((Collection)this.currentUpdates.get(uniqueSetting).getDiagnostics());
                ((VDiagnostic)controlDiagnosticMap.get(control)).getDiagnostics().addAll((Collection)this.currentUpdates.get(uniqueSetting).getDiagnostics());
                if (control.getDiagnostic() == null) continue;
                for (Object diagnosticObject : control.getDiagnostic().getDiagnostics()) {
                    UniqueSetting uniqueSetting2;
                    EObject diagnosticEobject;
                    Diagnostic diagnostic = (Diagnostic)Diagnostic.class.cast(diagnosticObject);
                    if (diagnostic.getData().size() < 2 || !EObject.class.isInstance(diagnostic.getData().get(0)) || !EStructuralFeature.class.isInstance(diagnostic.getData().get(1)) || !this.isObjectStillValid(diagnosticEobject = (EObject)EObject.class.cast(diagnostic.getData().get(0))) || this.currentUpdates.containsKey(uniqueSetting2 = UniqueSetting.createSetting((EObject)diagnosticEobject, (EStructuralFeature)((EStructuralFeature)EStructuralFeature.class.cast(diagnostic.getData().get(1)))))) continue;
                    ((VDiagnostic)controlDiagnosticMap.get(control)).getDiagnostics().add(diagnosticObject);
                }
            }
        }
        this.updateAndPropagate(controlDiagnosticMap);
    }

    private boolean isObjectStillValid(EObject diagnosticEobject) {
        EObject toCheck = diagnosticEobject;
        while (toCheck != null && toCheck != this.context.getDomainModel()) {
            toCheck = toCheck.eContainer();
        }
        return toCheck == this.context.getDomainModel();
    }

    private void updateAndPropagate(Map<VElement, VDiagnostic> controlDiagnosticMap) {
        for (VElement control : controlDiagnosticMap.keySet()) {
            control.setDiagnostic(controlDiagnosticMap.get(control));
            this.reevaluateToTop(control.eContainer(), controlDiagnosticMap);
        }
    }

    private void reevaluateToTop(EObject parent, Map<VElement, VDiagnostic> controlDiagnosticMap) {
        while (parent != null) {
            EObject newParent = parent.eContainer();
            if (!VElement.class.isInstance(parent)) {
                parent = newParent;
                continue;
            }
            VElement vElement = (VElement)parent;
            VDiagnostic vDiagnostic = VViewFactory.eINSTANCE.createDiagnostic();
            if (controlDiagnosticMap.containsKey(vElement)) {
                vDiagnostic.getDiagnostics().addAll((Collection)controlDiagnosticMap.get(vElement).getDiagnostics());
            }
            for (EObject eObject : vElement.eContents()) {
                VElement childElement;
                if (!VElement.class.isInstance(eObject) || (childElement = (VElement)eObject).getDiagnostic() == null || !childElement.isEnabled() || !childElement.isVisible()) continue;
                vDiagnostic.getDiagnostics().addAll((Collection)childElement.getDiagnostic().getDiagnostics());
            }
            vElement.setDiagnostic(vDiagnostic);
            parent = newParent;
        }
    }

    private void validateAndCollectSettings(EObject eObject) {
        Diagnostic diagnostic = this.getDiagnosticForEObject(eObject);
        for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
            UniqueSetting uniqueSetting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)feature);
            if (this.currentUpdates.containsKey(uniqueSetting)) continue;
            this.currentUpdates.put(uniqueSetting, VViewFactory.eINSTANCE.createDiagnostic());
        }
        this.analyzeDiagnostic(diagnostic);
    }

    private void analyzeDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getData().size() > 1) {
            if (InternalEObject.class.isInstance(diagnostic.getData().get(0)) && EStructuralFeature.class.isInstance(diagnostic.getData().get(1))) {
                EStructuralFeature eStructuralFeature;
                InternalEObject internalEObject = (InternalEObject)diagnostic.getData().get(0);
                EStructuralFeature.Setting setting = internalEObject.eSetting(eStructuralFeature = (EStructuralFeature)diagnostic.getData().get(1));
                UniqueSetting uniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)setting);
                if (!this.currentUpdates.containsKey(uniqueSetting)) {
                    this.currentUpdates.put(uniqueSetting, VViewFactory.eINSTANCE.createDiagnostic());
                }
                this.currentUpdates.get(uniqueSetting).getDiagnostics().add((Object)diagnostic);
            }
        } else {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                this.analyzeDiagnostic(childDiagnostic);
            }
        }
    }

    public Diagnostic getDiagnosticForEObject(EObject object) {
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator(object.eClass().getEPackage());
        BasicDiagnostic diagnostics = Diagnostician.INSTANCE.createDefaultDiagnostic(object);
        if (validator == null) {
            validator = new EObjectValidator();
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        LinkedHashMap<Class, ECPSubstitutionLabelProvider> context = new LinkedHashMap<Class, ECPSubstitutionLabelProvider>();
        context.put(EValidator.SubstitutionLabelProvider.class, new ECPSubstitutionLabelProvider((AdapterFactory)adapterFactory));
        context.put(EValidator.class, (ECPSubstitutionLabelProvider)validator);
        validator.validate(object, (DiagnosticChain)diagnostics, context);
        adapterFactory.dispose();
        LinkedHashMap<EStructuralFeature, DiagnosticChain> diagnosticMap = new LinkedHashMap<EStructuralFeature, DiagnosticChain>();
        for (Diagnostic child : diagnostics.getChildren()) {
            if (!DiagnosticChain.class.isInstance(child) || !this.checkDiagnosticData(child)) continue;
            diagnosticMap.put((EStructuralFeature)child.getData().get(1), (DiagnosticChain)child);
        }
        for (ValidationProvider validationProvider : this.validationProviders) {
            List<Diagnostic> additionValidation = validationProvider.validate(object);
            for (Diagnostic additionDiagnostic : additionValidation) {
                if (diagnosticMap.containsKey(additionDiagnostic.getData().get(1))) {
                    ((DiagnosticChain)diagnosticMap.get(additionDiagnostic.getData().get(1))).add(additionDiagnostic);
                    continue;
                }
                diagnostics.add(additionDiagnostic);
            }
        }
        return diagnostics;
    }

    private boolean checkDiagnosticData(Diagnostic diagnostic) {
        List data = diagnostic.getData();
        if (data.size() < 2) {
            return false;
        }
        if (!EObject.class.isInstance(data.get(0))) {
            return false;
        }
        return EStructuralFeature.class.isInstance(data.get(1));
    }

    @Override
    public void addValidationProvider(ValidationProvider validationProvider) {
        this.validationProviders.add(validationProvider);
        this.validate(this.getAllEObjects(this.context.getDomainModel()));
    }

    @Override
    public void removeValidationProvider(ValidationProvider validationProvider) {
        this.validationProviders.remove(validationProvider);
        this.validate(this.getAllEObjects(this.context.getDomainModel()));
    }

    @Override
    public void registerValidationListener(ViewValidationListener listener) {
        this.validationListeners.add(listener);
        listener.onNewValidation(this.getDiagnosticResult());
    }

    private Set<Diagnostic> getDiagnosticResult() {
        LinkedHashSet<Diagnostic> result = new LinkedHashSet<Diagnostic>();
        VDiagnostic diagnostic = this.context.getViewModel().getDiagnostic();
        if (diagnostic != null) {
            for (Object diagObject : diagnostic.getDiagnostics()) {
                result.add((Diagnostic)diagObject);
            }
        }
        return result;
    }

    @Override
    public void deregisterValidationListener(ViewValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    public void childViewModelContextAdded(ViewModelContext childContext) {
    }

    private class ValidationDomainModelChangeListener
    implements ModelChangeAddRemoveListener {
        private ValidationDomainModelChangeListener() {
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (ValidationNotification.class.isInstance(notification.getRawNotification())) {
                ValidationServiceImpl.this.validate(notification.getNotifier());
                return;
            }
            Notification rawNotification = notification.getRawNotification();
            switch (rawNotification.getEventType()) {
                case 3: {
                    LinkedHashSet<EObject> toValidate = new LinkedHashSet<EObject>();
                    toValidate.add(notification.getNotifier());
                    if (EReference.class.isInstance(notification.getStructuralFeature())) {
                        toValidate.addAll(ValidationServiceImpl.this.getAllEObjects((EObject)notification.getRawNotification().getNewValue()));
                    }
                    ValidationServiceImpl.this.validate(toValidate);
                    break;
                }
                case 5: {
                    ValidationServiceImpl.this.validate(notification.getNotifier());
                    if (!EReference.class.isInstance(notification.getStructuralFeature())) break;
                    ValidationServiceImpl.this.validate((Collection)notification.getRawNotification().getNewValue());
                    break;
                }
                case 4: {
                    if (EReference.class.isInstance(rawNotification.getFeature())) {
                        ValidationServiceImpl.this.cleanControlDiagnostics((EObject)EObject.class.cast(notification.getNotifier()), (EReference)EReference.class.cast(rawNotification.getFeature()), (EObject)EObject.class.cast(rawNotification.getOldValue()));
                    }
                }
                case 6: {
                    ValidationServiceImpl.this.validate(ValidationServiceImpl.this.getAllEObjects(notification.getNotifier()));
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    Object newValue;
                    ValidationServiceImpl.this.validate(notification.getNotifier());
                    if (!EReference.class.isInstance(notification.getStructuralFeature()) || notification.getRawNotification().getNewValue() == null || !EObject.class.isInstance(newValue = notification.getRawNotification().getNewValue())) break;
                    ValidationServiceImpl.this.validate((EObject)newValue);
                }
            }
        }

        public void notifyAdd(Notifier notifier) {
        }

        public void notifyRemove(Notifier notifier) {
        }
    }

    private class ViewModelChangeListener
    implements ModelChangeAddRemoveListener {
        private ViewModelChangeListener() {
        }

        public void notifyChange(ModelChangeNotification notification) {
            if ((VViewPackage.eINSTANCE.getElement_Enabled() == notification.getRawNotification().getFeature() || VViewPackage.eINSTANCE.getElement_Visible() == notification.getRawNotification().getFeature()) && VViewPackage.eINSTANCE.getControl().isInstance((Object)notification.getNotifier())) {
                VDomainModelReference domainModelReference;
                VControl control = (VControl)notification.getNotifier();
                if (VViewPackage.eINSTANCE.getElement_Enabled() == notification.getRawNotification().getFeature()) {
                    control.setDiagnostic(null);
                }
                if ((domainModelReference = control.getDomainModelReference()) == null) {
                    return;
                }
                Iterator settings = domainModelReference.getIterator();
                LinkedHashSet<EObject> eObjectsToValidate = new LinkedHashSet<EObject>();
                while (settings.hasNext()) {
                    eObjectsToValidate.add(((EStructuralFeature.Setting)settings.next()).getEObject());
                }
                for (EObject eObject : eObjectsToValidate) {
                    ValidationServiceImpl.this.validate(eObject);
                }
            }
            if (!VElement.class.isInstance(notification.getNotifier())) {
                return;
            }
            switch (notification.getRawNotification().getEventType()) {
                case 4: 
                case 6: {
                    Map map = Collections.emptyMap();
                    ValidationServiceImpl.this.reevaluateToTop(notification.getNotifier(), map);
                    break;
                }
            }
        }

        public void notifyAdd(Notifier notifier) {
            if (VControl.class.isInstance(notifier)) {
                VDomainModelReference domainModelReference = ((VControl)VControl.class.cast(notifier)).getDomainModelReference();
                if (domainModelReference == null) {
                    return;
                }
                Iterator settings = domainModelReference.getIterator();
                LinkedHashSet<EObject> eObjectsToValidate = new LinkedHashSet<EObject>();
                while (settings.hasNext()) {
                    eObjectsToValidate.add(((EStructuralFeature.Setting)settings.next()).getEObject());
                }
                for (EObject eObject : eObjectsToValidate) {
                    ValidationServiceImpl.this.validate(eObject);
                }
            }
        }

        public void notifyRemove(Notifier notifier) {
        }
    }
}

