/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.controls.AbstractTextControl;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ControlMessages;
import org.eclipse.emf.ecp.edit.internal.swt.util.DateUtil;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class XmlDateControlText
extends AbstractTextControl {
    private Button bDate;

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_xmldate";
    }

    @Override
    protected String getUnsetLabelText() {
        return ControlMessages.XmlDateControlText_NoDateSetClickToSetDate;
    }

    @Override
    protected String getUnsetButtonTooltip() {
        return ControlMessages.XmlDateControlText_UnsetDate;
    }

    @Override
    protected void customizeText(Text text) {
        super.customizeText(text);
        text.setMessage(((SimpleDateFormat)this.setupFormat()).toPattern());
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.bDate.setVisible(editable);
    }

    @Override
    protected void fillControlComposite(Composite composite) {
        Composite main = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)main);
        super.fillControlComposite(main);
        this.bDate = new Button(main, 8);
        this.bDate.setImage(Activator.getImage("icons/date.png"));
        this.bDate.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_xmldate");
        this.bDate.addSelectionListener((SelectionListener)new SelectionAdapterExtension());
    }

    @Override
    public Binding bindValue() {
        ISWTObservableValue value = SWTObservables.observeText((Control)this.getText(), (int)16);
        DateTargetToModelUpdateStrategy targetToModelUpdateStrategy = new DateTargetToModelUpdateStrategy();
        DateModelToTargetUpdateStrategy modelToTargetUpdateStrategy = new DateModelToTargetUpdateStrategy();
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), (UpdateValueStrategy)targetToModelUpdateStrategy, (UpdateValueStrategy)modelToTargetUpdateStrategy);
        this.createTooltipBinding((UpdateValueStrategy)targetToModelUpdateStrategy, (UpdateValueStrategy)modelToTargetUpdateStrategy);
        return binding;
    }

    protected DateFormat setupFormat() {
        return DateFormat.getDateInstance(2, this.getLocale());
    }

    private class DateModelToTargetUpdateStrategy
    extends AbstractTextControl.ModelToTargetUpdateStrategy {
        private DateModelToTargetUpdateStrategy() {
            super(XmlDateControlText.this);
        }

        @Override
        public Object convertValue(Object value) {
            DateFormat format = XmlDateControlText.this.setupFormat();
            XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)value;
            if (gregorianCalendar == null) {
                return null;
            }
            Date date = gregorianCalendar.toGregorianCalendar().getTime();
            return format.format(date);
        }
    }

    private class DateTargetToModelUpdateStrategy
    extends AbstractTextControl.TargetToModelUpdateStrategy {
        private final DateFormat format;

        DateTargetToModelUpdateStrategy() {
            super(XmlDateControlText.this);
            this.format = XmlDateControlText.this.setupFormat();
        }

        @Override
        protected Object convertValue(Object value) {
            try {
                Date date = null;
                if (String.class.isInstance(value)) {
                    date = this.format.parse((String)value);
                } else if (Date.class.isInstance(value)) {
                    date = (Date)value;
                } else if (value == null) {
                    return value;
                }
                String formatedDate = this.format.format(date);
                XmlDateControlText.this.getText().setText(formatedDate);
                Calendar targetCal = Calendar.getInstance();
                targetCal.setTime(date);
                return DateUtil.convertOnlyDateToXMLGregorianCalendar(targetCal);
            }
            catch (ParseException parseException) {
                return this.revertToOldValue(value);
            }
        }

        private Object revertToOldValue(Object value) {
            if (XmlDateControlText.this.getFirstStructuralFeature().getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = XmlDateControlText.this.getModelValue().getValue();
            MessageDialog messageDialog = new MessageDialog(XmlDateControlText.this.getText().getShell(), ControlMessages.XmlDateControlText_InvalidNumber, null, ControlMessages.XmlDateControlText_NumberInvalidValueWillBeUnset, 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                @Override
                public void handleResult(int codeResult) {
                }
            }.execute();
            if (result == null) {
                XmlDateControlText.this.getText().setText("");
            } else {
                XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)result;
                Date date = gregorianCalendar.toGregorianCalendar().getTime();
                XmlDateControlText.this.getText().setText(this.format.format(date));
            }
            if (XmlDateControlText.this.getFirstStructuralFeature().isUnsettable() && result == null) {
                XmlDateControlText.this.showUnsetLabel();
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }

    private final class SelectionAdapterExtension
    extends SelectionAdapter {
        private SelectionAdapterExtension() {
        }

        public void widgetSelected(SelectionEvent e) {
            final Shell dialog = new Shell(XmlDateControlText.this.getText().getShell(), 0);
            dialog.setLayout((Layout)new GridLayout(1, false));
            DateTime calendar = new DateTime((Composite)dialog, 3072);
            XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)XmlDateControlText.this.getModelValue().getValue();
            Calendar cal = Calendar.getInstance(XmlDateControlText.this.getLocale());
            if (gregorianCalendar != null) {
                cal.setTime(gregorianCalendar.toGregorianCalendar().getTime());
            }
            calendar.setDate(cal.get(1), cal.get(2), cal.get(5));
            ISWTObservableValue dateObserver = SWTObservables.observeSelection((Control)calendar);
            final Binding binding = XmlDateControlText.this.getDataBindingContext().bindValue((IObservableValue)dateObserver, XmlDateControlText.this.getModelValue(), (UpdateValueStrategy)new DateTargetToModelUpdateStrategy(), (UpdateValueStrategy)new DateModelToTargetUpdateStrategy());
            binding.updateModelToTarget();
            calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    dialog.close();
                }
            });
            calendar.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent event) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    dialog.close();
                }

                public void focusGained(FocusEvent event) {
                }
            });
            dialog.pack();
            dialog.layout();
            dialog.setLocation(XmlDateControlText.this.bDate.getParent().toDisplay(((XmlDateControlText)XmlDateControlText.this).bDate.getLocation().x + ((XmlDateControlText)XmlDateControlText.this).bDate.getSize().x - dialog.getSize().x, ((XmlDateControlText)XmlDateControlText.this).bDate.getLocation().y + ((XmlDateControlText)XmlDateControlText.this).bDate.getSize().y));
            dialog.open();
        }
    }
}

