/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.handlers.URIHandler;

public class ResourceDeserializer
extends JsonDeserializer<Resource> {
    private final URIHandler uriHandler;

    public ResourceDeserializer(URIHandler uriHandler) {
        this.uriHandler = uriHandler;
    }

    public boolean isCachable() {
        return true;
    }

    public Resource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this.deserialize(jp, ctxt, null);
    }

    public Resource deserialize(JsonParser jp, DeserializationContext ctxt, Resource intoValue) throws IOException {
        EObject value;
        Resource resource = this.getResource(ctxt, intoValue);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource");
        }
        EMFContext.init(resource, (DatabindContext)ctxt);
        if (!jp.hasCurrentToken()) {
            jp.nextToken();
        }
        JsonDeserializer deserializer = ctxt.findRootValueDeserializer(ctxt.constructType(EObject.class));
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                EObject value2 = (EObject)deserializer.deserialize(jp, ctxt);
                if (value2 == null) continue;
                resource.getContents().add((Object)value2);
            }
        } else if (jp.getCurrentToken() == JsonToken.START_OBJECT && (value = (EObject)deserializer.deserialize(jp, ctxt)) != null) {
            resource.getContents().add((Object)value);
        }
        EMFContext.resolve(ctxt, this.uriHandler);
        return resource;
    }

    private Resource getResource(DeserializationContext context, Resource resource) {
        if (resource == null) {
            URI uri;
            ResourceSet resourceSet;
            resource = EMFContext.getResource((DatabindContext)context);
            if (resource == null && (resource = (resourceSet = this.getResourceSet(context)).createResource(uri = this.getURI(context))) == null) {
                throw new RuntimeException("Cannot create resource for uri " + uri);
            }
        } else {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet == null) {
                resourceSet = this.getResourceSet(context);
                resourceSet.getResources().add((Object)resource);
            }
            return resource;
        }
        return resource;
    }

    protected ResourceSet getResourceSet(DeserializationContext context) {
        ResourceSet resourceSet = EMFContext.getResourceSet((DatabindContext)context);
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
            context.setAttribute((Object)EMFContext.Attributes.RESOURCE_SET, (Object)resourceSet);
        }
        return resourceSet;
    }

    private URI getURI(DeserializationContext ctxt) {
        URI uri = EMFContext.getURI((DatabindContext)ctxt);
        if (uri == null) {
            uri = URI.createURI((String)"default");
        }
        return uri;
    }

    public Class<Resource> handledType() {
        return Resource.class;
    }
}

