/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.views;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfatic.ui.views.TypesView;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class TypesViewContentProvider
implements ITreeContentProvider {
    TypesView _typesView = null;
    EClass lastShown = null;

    public TypesViewContentProvider(TypesView tv) {
        this._typesView = tv;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof WeakReference) {
            WeakReference wrC = (WeakReference)parent;
            EClass eC = (EClass)wrC.get();
            return new EClass[]{eC};
        }
        if (parent instanceof EClass) {
            EClass eC = (EClass)parent;
            return this.getChildren(eC);
        }
        return new Object[0];
    }

    public Object getParent(Object child) {
        EClass eC = (EClass)child;
        if (this._typesView.isShowinSuperTypeHierarchy()) {
            if (this.subClassesOf(eC).length > 0) {
                EClass fstSubtype = this.subClassesOf(eC)[0];
                return fstSubtype;
            }
            return null;
        }
        if (eC.getESuperTypes().size() > 0) {
            EClass firstParent = (EClass)eC.getESuperTypes().get(0);
            return firstParent;
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        EClass eC = (EClass)parent;
        Object[] res = this._typesView.isShowinSuperTypeHierarchy() ? this.superTypesOf(eC) : this.subClassesOf(eC);
        return res;
    }

    private EClass[] superTypesOf(EClass eC) {
        Object[] res = new EClass[eC.getESuperTypes().size()];
        eC.getESuperTypes().toArray(res);
        return res;
    }

    private EClass[] subClassesOf(EClass eC) {
        Collection<EObject> subClasses = TypesViewContentProvider.findOpposites((EObject)eC, EcorePackage.eINSTANCE.getEClass_ESuperTypes());
        EClass[] res = new EClass[subClasses.size()];
        int i = 0;
        for (EObject sc : subClasses) {
            if (!(sc instanceof EClass)) continue;
            res[i] = (EClass)sc;
            ++i;
        }
        return res;
    }

    public boolean hasChildren(Object parent) {
        EClass eC = (EClass)parent;
        boolean res = this._typesView.isShowinSuperTypeHierarchy() ? this.superTypesOf(eC).length != 0 : this.subClassesOf(eC).length != 0;
        return res;
    }

    public static Collection<EObject> findOpposites(final EObject object, final EReference outgoingEReference) {
        Collection<EStructuralFeature.Setting> settings = new EcoreUtil.UsageCrossReferencer(object.eResource().getResourceSet()){

            protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedObject) {
                return object == crossReferencedObject && eReference == outgoingEReference;
            }

            public Collection<EStructuralFeature.Setting> findUsage(EObject eObject) {
                return super.findUsage(eObject);
            }
        }.findUsage(object);
        ArrayList<EObject> references = new ArrayList<EObject>();
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != outgoingEReference) continue;
            references.add(setting.getEObject());
        }
        return references;
    }
}

