/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.ui.editor;

import java.util.ArrayList;
import org.eclipse.gymnast.runtime.ui.util.LDTColorProvider;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.RGB;

public abstract class LDTCodeScanner
extends RuleBasedScanner {
    private LDTColorProvider _colorProvider;
    private ArrayList<IRule> _rules = new ArrayList();
    private WordRule _idRule;

    public void dispose() {
        this._colorProvider.dispose();
    }

    public LDTCodeScanner() {
        this._colorProvider = new LDTColorProvider();
        this.initSetup();
    }

    public IToken getLiteralToken() {
        return this.makeToken(LDTColorProvider.DARK_BLUE, null, 0);
    }

    public void initLiterals() {
        IToken literalToken = this.getLiteralToken();
        this.addRule((IRule)new SingleLineRule("\"", "\"", literalToken));
        this.addRule((IRule)new SingleLineRule("'", "'", literalToken));
    }

    public void initKeywords() {
    }

    public IToken getCommentToken() {
        return this.makeToken(LDTColorProvider.DARK_GREEN, null, 0);
    }

    public void initComments() {
        IToken commentToken = this.getCommentToken();
        this.addRule((IRule)new EndOfLineRule("//", commentToken));
        this.addRule((IRule)new MultiLineRule("/*", "*/", commentToken));
    }

    public void initSetup() {
        this._rules = new ArrayList();
        this.addRule((IRule)new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        this._idRule = new WordRule((IWordDetector)new IDDetector(), this.makeToken(this.getIdColor()));
        this.addRule((IRule)this._idRule);
        this.initLiterals();
        this.initKeywords();
        this.initComments();
        IRule[] result = new IRule[this._rules.size()];
        this._rules.toArray(result);
        this.setRules(result);
    }

    protected void addRule(IRule rule) {
        this._rules.add(rule);
    }

    protected void addKeywords(String[] keywords, RGB color) {
        int i = 0;
        while (i < keywords.length) {
            this._idRule.addWord(keywords[i], this.makeToken(color));
            ++i;
        }
    }

    protected void addKeywords(String[] keywords, RGB foregroundColor, RGB backgroundColor, int style) {
        int i = 0;
        while (i < keywords.length) {
            this._idRule.addWord(keywords[i], this.makeToken(foregroundColor, backgroundColor, style));
            ++i;
        }
    }

    public RGB getIdColor() {
        return LDTColorProvider.BLACK;
    }

    protected IToken makeToken(RGB foregroundColor) {
        TextAttribute attr = new TextAttribute(this._colorProvider.getColor(foregroundColor));
        return new Token((Object)attr);
    }

    protected IToken makeToken(RGB foregroundColor, RGB backgroundColor, int style) {
        TextAttribute attr = new TextAttribute(this._colorProvider.getColor(foregroundColor), this._colorProvider.getColor(backgroundColor), style);
        return new Token((Object)attr);
    }

    public static class IDDetector
    implements IWordDetector {
        public boolean isWordPart(char c) {
            return Character.isUnicodeIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isUnicodeIdentifierStart(c);
        }
    }

    public static class TokenIDDetector
    implements IWordDetector {
        public boolean isWordPart(char c) {
            if (Character.isUpperCase(c)) {
                return true;
            }
            return c == '_';
        }

        public boolean isWordStart(char c) {
            if (Character.isUpperCase(c)) {
                return true;
            }
            return c == '_';
        }
    }

    public static class WhitespaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }
}

