/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.emf.emfatic.ui.EmfaticUIPlugin;
import org.eclipse.gymnast.runtime.ui.util.LDTColorProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class HighlightingManager {
    private static final String PREFERENCE_PREFIX = "org.eclipse.emf.emfatic.ui";
    public static final RGB COMMENT_COLOR = LDTColorProvider.DARK_GREEN;
    public static final RGB LITERAL_COLOR = LDTColorProvider.DARK_BLUE;
    public static final RGB ID_COLOR = LDTColorProvider.BLACK;
    public static final RGB NORMAL_KEYWORDS_COLOR = LDTColorProvider.BLUE;
    public static final RGB SPECIAL_KEYWORDS_COLOR = LDTColorProvider.DARK_BLUE;
    public static final RGB BASIC_TYPES_COLOR = LDTColorProvider.DARK_GREEN;
    public static final RGB COMMENT_COLOR_DARK = new RGB(190, 218, 0);
    public static final RGB LITERAL_COLOR_DARK = new RGB(115, 148, 255);
    public static final RGB ID_COLOR_DARK = LDTColorProvider.WHITE;
    public static final RGB NORMAL_KEYWORDS_COLOR_DARK = new RGB(182, 252, 255);
    public static final RGB SPECIAL_KEYWORDS_COLOR_DARK = new RGB(243, 191, 0);
    public static final RGB BASIC_TYPES_COLOR_DARK = new RGB(118, 167, 37);
    public static final String COMMENT_COLOR_PREF = HighlightingManager.prefixPreference("commentColor");
    public static final String LITERAL_COLOR_PREF = HighlightingManager.prefixPreference("literalColor");
    public static final String ID_COLOR_PREF = HighlightingManager.prefixPreference("idColor");
    public static final String NORMAL_KEYWORDS_COLOR_PREF = HighlightingManager.prefixPreference("normalKeywordsColor");
    public static final String SPECIAL_KEYWORDS_COLOR_PREF = HighlightingManager.prefixPreference("specialKeywordsColor");
    public static final String BASIC_TYPES_COLOR_PREF = HighlightingManager.prefixPreference("basicTypesColor");
    public static final List<String> COLOR_PREFERENCES = new ArrayList<String>(Arrays.asList(COMMENT_COLOR_PREF, LITERAL_COLOR_PREF, ID_COLOR_PREF, NORMAL_KEYWORDS_COLOR_PREF, SPECIAL_KEYWORDS_COLOR_PREF, BASIC_TYPES_COLOR_PREF));
    protected IPreferenceStore preferenceStore = EmfaticUIPlugin.getDefault().getPreferenceStore();

    private static String prefixPreference(String preference) {
        return String.format("%s.%s", PREFERENCE_PREFIX, preference);
    }

    public HighlightingManager() {
        this.initialiseDefaultColors();
    }

    protected boolean areDefaultColorsCorrect() {
        return HighlightingManager.isDarkThemeEnabled() && PreferenceConverter.getDefaultColor((IPreferenceStore)this.preferenceStore, (String)BASIC_TYPES_COLOR_PREF).equals((Object)BASIC_TYPES_COLOR_DARK) || !HighlightingManager.isDarkThemeEnabled() && PreferenceConverter.getDefaultColor((IPreferenceStore)this.preferenceStore, (String)BASIC_TYPES_COLOR_PREF).equals((Object)BASIC_TYPES_COLOR);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void initialiseDefaultColors() {
        if (!this.areDefaultColorsCorrect()) {
            this.setDefaults();
        }
    }

    public boolean isColorPreference(String preference) {
        return preference.startsWith(PREFERENCE_PREFIX);
    }

    protected void setDefaults() {
        if (HighlightingManager.isDarkThemeEnabled()) {
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)COMMENT_COLOR_PREF, (RGB)COMMENT_COLOR_DARK);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)LITERAL_COLOR_PREF, (RGB)LITERAL_COLOR_DARK);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)ID_COLOR_PREF, (RGB)ID_COLOR_DARK);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)NORMAL_KEYWORDS_COLOR_PREF, (RGB)NORMAL_KEYWORDS_COLOR_DARK);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)SPECIAL_KEYWORDS_COLOR_PREF, (RGB)SPECIAL_KEYWORDS_COLOR_DARK);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)BASIC_TYPES_COLOR_PREF, (RGB)BASIC_TYPES_COLOR_DARK);
        } else {
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)COMMENT_COLOR_PREF, (RGB)COMMENT_COLOR);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)LITERAL_COLOR_PREF, (RGB)LITERAL_COLOR);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)ID_COLOR_PREF, (RGB)ID_COLOR);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)NORMAL_KEYWORDS_COLOR_PREF, (RGB)NORMAL_KEYWORDS_COLOR);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)SPECIAL_KEYWORDS_COLOR_PREF, (RGB)SPECIAL_KEYWORDS_COLOR);
            PreferenceConverter.setDefault((IPreferenceStore)this.preferenceStore, (String)BASIC_TYPES_COLOR_PREF, (RGB)BASIC_TYPES_COLOR);
        }
    }

    public static boolean isDarkThemeEnabled() {
        Display display;
        block3: {
            try {
                display = Display.getDefault();
                if (display != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        IThemeEngine engine = (IThemeEngine)display.getData("org.eclipse.e4.ui.css.swt.theme");
        ITheme activeTheme = engine.getActiveTheme();
        return activeTheme != null && "org.eclipse.e4.ui.css.theme.e4_dark".equals(activeTheme.getId());
    }

    protected RGB getColor(String preference) {
        return PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)preference);
    }

    public RGB getCommentColor() {
        return this.getColor(COMMENT_COLOR_PREF);
    }

    public RGB getLiteralColor() {
        return this.getColor(LITERAL_COLOR_PREF);
    }

    public RGB getIdColor() {
        return this.getColor(ID_COLOR_PREF);
    }

    public RGB getNormalKeywordsColor() {
        return this.getColor(NORMAL_KEYWORDS_COLOR_PREF);
    }

    public RGB getSpecialKeywordsColor() {
        return this.getColor(SPECIAL_KEYWORDS_COLOR_PREF);
    }

    public RGB getBasicTypesColor() {
        return this.getColor(BASIC_TYPES_COLOR_PREF);
    }
}

