/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.viewers;

import com.google.inject.Inject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.edit.EditingDomainFinder;
import org.eclipse.emf.parsley.viewers.TableViewerCellEditorFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;

public class TableViewerEditingSupport
extends EditingSupport {
    private EStructuralFeature eStructuralFeature;
    private Object initialCellValue;
    @Inject
    private EditingDomainFinder editingDomainFinder;
    @Inject
    private TableViewerCellEditorFactory cellEditorFactory;

    public TableViewerEditingSupport(ColumnViewer viewer, EStructuralFeature eStructuralFeature) {
        super(viewer);
        this.eStructuralFeature = eStructuralFeature;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditorFactory.createCellEditor((Composite)this.getViewer().getControl(), element, this.eStructuralFeature);
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        super.initializeCellEditorValue(cellEditor, cell);
        this.initialCellValue = cellEditor.getValue();
    }

    protected Object getValue(Object element) {
        EObject eObject = (EObject)element;
        return eObject.eGet(this.eStructuralFeature);
    }

    protected void setValue(Object element, Object value) {
        EObject eObject = (EObject)element;
        boolean modelNeedsToBeUpdated = false;
        if (this.initialCellValue == null) {
            modelNeedsToBeUpdated = value != null;
        } else {
            boolean bl = modelNeedsToBeUpdated = !this.initialCellValue.equals(value);
        }
        if (modelNeedsToBeUpdated) {
            EditingDomain domain = this.editingDomainFinder.getEditingDomainFor(eObject);
            SetCommand setCommand = new SetCommand(domain, eObject, this.eStructuralFeature, value);
            domain.getCommandStack().execute((Command)setCommand);
        }
    }
}

