/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.riscv.core;

import java.io.File;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.internal.managedbuild.cross.core.Activator;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.Option;

public class EnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static boolean DEBUG_PATH = true;

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (PathEnvironmentVariable.isVar(variableName)) {
            return PathEnvironmentVariable.create(configuration);
        }
        if (org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.getInstance().isDebugging()) {
            System.out.println("riscv.EnvironmentVariableSupplier.getVariable(" + variableName + "," + configuration.getName() + ") returns null");
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        PathEnvironmentVariable path = PathEnvironmentVariable.create(configuration);
        if (path != null) {
            return new IBuildEnvironmentVariable[]{path};
        }
        if (org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.getInstance().isDebugging()) {
            System.out.println("riscv.EnvironmentVariableSupplier.getVariables(" + configuration.getName() + ") returns empty array");
        }
        return new IBuildEnvironmentVariable[0];
    }

    private static class PathEnvironmentVariable
    implements IBuildEnvironmentVariable {
        public static String name = "PATH";
        private File path;

        private PathEnvironmentVariable(File path) {
            this.path = path;
        }

        public static PathEnvironmentVariable create(IConfiguration configuration) {
            IToolChain toolchain = configuration.getToolChain();
            IProject project = (IProject)configuration.getManagedProject().getOwner();
            Boolean preferXpacksBin = Option.getOptionBooleanValue(configuration, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.preferxpacksbin");
            String path = "";
            if (preferXpacksBin.booleanValue()) {
                IPath projectPath = project.getWorkspace().getRoot().getLocation().append(project.getFullPath());
                IPath xpackBinPath = projectPath.append("xpacks").append(".bin");
                path = xpackBinPath.toOSString();
            }
            PersistentPreferences commonPersistentPreferences = Activator.getInstance().getPersistentPreferences();
            String buildToolsPath = commonPersistentPreferences.getBuildToolsPath(project);
            if (path.isEmpty()) {
                path = buildToolsPath;
            } else if (!buildToolsPath.isEmpty()) {
                path = String.valueOf(path) + EclipseUtils.getPathSeparator();
                path = String.valueOf(path) + buildToolsPath;
            }
            IOption optionId = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.id");
            String toolchainId = (String)optionId.getValue();
            IOption optionName = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name");
            String toolchainName = (String)optionName.getValue();
            String toolchainPath = "";
            PersistentPreferences persistentPreferences = org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.getInstance().getPersistentPreferences();
            toolchainPath = persistentPreferences.getToolchainPath(toolchainId, toolchainName, project);
            if (path.isEmpty()) {
                path = toolchainPath;
            } else if (!toolchainPath.isEmpty()) {
                path = String.valueOf(path) + EclipseUtils.getPathSeparator();
                path = String.valueOf(path) + toolchainPath;
            }
            if (!path.isEmpty()) {
                if (path.indexOf("${") >= 0) {
                    path = PathEnvironmentVariable.resolveMacros(path, configuration);
                }
                File sysroot = new File(path);
                if (DEBUG_PATH && org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.getInstance().isDebugging()) {
                    System.out.println("riscv.PathEnvironmentVariable.create() PATH=" + sysroot + " cfg=" + configuration + " prj=" + configuration.getManagedProject().getOwner().getName());
                }
                return new PathEnvironmentVariable(sysroot);
            }
            if (org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.getInstance().isDebugging()) {
                System.out.println("riscv.PathEnvironmentVariable.create(" + configuration.getName() + ") returns null");
            }
            return null;
        }

        private static String resolveMacros(String str, IConfiguration configuration) {
            String result = str;
            try {
                result = ManagedBuildManager.getBuildMacroProvider().resolveValue(str, "", " ", 3, (Object)configuration);
            }
            catch (CdtVariableException e) {
                org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.log((String)("riscv.PathEnvironmentVariable.resolveMacros " + e.getMessage()));
            }
            if (org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.getInstance().isDebugging()) {
                org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator.log((String)("riscv.PathEnvironmentVariable.resolveMacros(\"" + str + "\", \"" + configuration.getName() + "\") = \"" + "\""));
            }
            return result;
        }

        public static boolean isVar(String name) {
            return Platform.getOS().equals("win32") ? name.equalsIgnoreCase(PathEnvironmentVariable.name) : name.equals(PathEnvironmentVariable.name);
        }

        public String getDelimiter() {
            return Platform.getOS().equals("win32") ? ";" : ":";
        }

        public String getName() {
            return name;
        }

        public int getOperation() {
            return 3;
        }

        public String getValue() {
            return this.path.getAbsolutePath();
        }
    }
}

